﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using BezelEditor.Foundation;

namespace Nintendo.Authoring.AuthoringEditor.Foundation
{
    public enum NspFileEnumeration
    {
        All,
        RootOnly,
        PatchedOnly,
        DiffPatch,
    }

    public class NspFileReadException : ApplicationException
    {
        public NspFileReadException(string nspFilePath, string errorMessages) :
            base($"{nspFilePath}: {errorMessages}")
        {
        }

        public NspFileReadException(string nspFilePath, string errorMessages, Exception innerException) :
            base($"{nspFilePath}: {errorMessages}", innerException)
        {
        }
    }

    public enum NspFileModifiedType
    {
        Unknown,
        Changed,
        Added,
        Removed
    }

    public class NspFileEnumerateParameter
    {
        public NspFileEnumeration EnumerationType { get; set; }
        public string DiffPatchNspFilePath { get; set; }
    }

    public class NspFileEntry
    {
        public string FilePath { get; set; }
        public ulong FileSize { get; set; }
        public NspFileModifiedType ModifiedType { get; set; }
        public ulong ModifiedFileSize { get; set; }
    }

    public interface INspFileEnumerable : IEnumerable<NspFileEntry>
    {

    }

    public interface INspFile
    {
        PathString NspPath { get; set; }
        INspFile OriginalNspFile { get; set; }
        bool IsExists { get; }
        bool IsAuthoringToolOperational { get; }

        INspFileEnumerable Files(NspFileEnumerateParameter parameter);

        string ReadAllText(string pathInNsp, Encoding encoding);
        string ReadAllText(string pathInNsp);

        Task<string> ReadAllTextAsync(string pathInNsp, Encoding encoding);
        Task<string> ReadAllTextAsync(string pathInNsp);

        Task<T> ReadXmlAsync<T>(string filePath, Encoding encoding);
        Task<T> ReadXmlAsync<T>(string filePath);

        Task ExtractContentAsync(ContentType contentType, string path);
        Task ExtractAsync(string pathInNsp, string path);
        Task ExtractFilesAsync(IDictionary<string, string> targets);
        Task ExtractAllAsync(PathString outputDir, Action<int> progressChanged, CancellationToken cancellationToken);

        NcaCompareResult GetNcaIdenticalResult(INspFile target, string contentType, string prefixPath = null,
            Action<float> onProgressChange = null, CancellationToken token = default(CancellationToken));
    }
}
