﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using System.Xml.Serialization;
using BezelEditor.Foundation;
using Nintendo.Authoring.AuthoringEditor.Foundation;

namespace Nintendo.Authoring.AuthoringEditor.Core
{
    public class NspPublishableChecker
    {
        public async Task<UnpublishableError> CheckUnpublishableErrorAsync(PathString nspPath, CancellationToken token = default(CancellationToken))
        {
            if (File.Exists(nspPath) == false)
                return null;

            var args = $"get-unpublishable-error --xml {nspPath.SurroundDoubleQuotes}";
            using (var job = AuthoringToolWrapper.Create(args))
            {
                job.IsRedirectStandardOutput = true;
                job.IsRedirectStandardError = true;

                job.Process.StartInfo.StandardOutputEncoding = Encoding.UTF8;

                job.Start();

                var exitCode = await job.WaitForExitAsync(x => x.ExitCode, token).ConfigureAwait(false);
                if (exitCode != 0)
                    return null;

                var serializer = new XmlSerializer(typeof(UnpublishableError));
                var xmlText = string.Join(Environment.NewLine, job.StandardOutput);
                using (var reader = new StringReader(xmlText))
                {
                    var unpublishableError = (UnpublishableError)serializer.Deserialize(reader);
                    // 無効なアイテムを削除する
                    {
                        var errors = unpublishableError.Content.Errors;
                        var invalidErrors = errors.Where(x => x.Message == null).ToArray();
                        foreach (var e in invalidErrors)
                            errors.Remove(e);
                    }
                    return unpublishableError;
                }
            }
        }
    }
}
