﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Globalization;
using System.Xml.Serialization;
using BezelEditor.Mvvm;
using Nintendo.Authoring.AuthoringEditor.Foundation;

namespace Nintendo.Authoring.AuthoringEditor.Core
{
    public enum ApplicationMetaErrorSeverity
    {
        Error,
        Warning,
        Information
    }

    [XmlRoot("ApplicationMetaError")]
    public class ApplicationMetaErrorContainer
    {
        [XmlArrayItem("Error")]
        public List<ApplicationMetaError> Errors { set; get; }

        public string ToXml()
        {
            var ns = new XmlSerializerNamespaces();
            ns.Add(string.Empty, string.Empty);

            using (var sw = new StringWriterUtf8())
            {
                var serializer = new XmlSerializer(typeof(ApplicationMetaErrorContainer));
                serializer.Serialize(sw, this, ns);
                return sw.ToString();
            }
        }
    }

    public class ApplicationMetaError : ModelBase
    {
        #region Severity

        private ApplicationMetaErrorSeverity _ErrorSeverity;

        public ApplicationMetaErrorSeverity ErrorSeverity
        {
            get { return _ErrorSeverity; }
            set { SetProperty(ref _ErrorSeverity, value); }
        }

        #endregion

        #region Id

        private string _Id;

        public string Id
        {
            get { return _Id; }
            set { SetProperty(ref _Id, value); }
        }

        #endregion

        #region Title

        private string _Title;

        public string Title
        {
            get { return _Title; }
            set { SetProperty(ref _Title, value); }
        }

        #endregion

        #region Description

        private string _Description;

        public string Description
        {
            get { return _Description; }
            set { SetProperty(ref _Description, value); }
        }

        #endregion

        #region TitleTag

        private string _TitleTag;

        [XmlIgnore]
        public string TitleTag
        {
            get { return _TitleTag; }
            set { SetProperty(ref _TitleTag, value); }
        }

        #endregion

        #region DescriptionTag

        private string _DescriptionTag;

        [XmlIgnore]
        public string DescriptionTag
        {
            get { return _DescriptionTag; }
            set { SetProperty(ref _DescriptionTag, value); }
        }

        #endregion

        public CulturizedMessage CulturizedTitle { get; set; }
        public CulturizedMessage CulturizedDescription { get; set; }
    }

    public class CulturizedMessage
    {
        private Lazy<Dictionary<string, string>> _culturizedMessage =
            new Lazy<Dictionary<string, string>>(() => new Dictionary<string, string>());

        public string DefaultMessage { get; set; }

        public string this[string cultureName]
        {
            get
            {
                string message;
                if (_culturizedMessage.Value.TryGetValue(cultureName, out message))
                    return message;
                return DefaultMessage;
            }
            set { _culturizedMessage.Value[cultureName] = value; }
        }
    }
}
