﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using NAudio.CoreAudioApi;
using NAudio.Wave;
using System;

namespace SystemAudioMonitor
{
    public class WavePlayback : IDisposable, IWaveProcessor
    {
        private static readonly int WasapiOutLatency = 10;
        private BufferedWaveProvider _bufferedWaveProvider;
        private VolumeWaveProvider16 _volumeWaveProvider;
        private IWavePlayer _player;
        private float _volume = 0.0f;
        public float Volume
        {
            get
            {
                return _volume;
            }
            set
            {
                _volume = value;
                _volumeWaveProvider.Volume = value;
            }
        }

        public WavePlayback(WaveformFormat format)
        {
            var waveFormat = new WaveFormat(format.SampleRate, format.BitDepth, format.ChannelCount);
            _bufferedWaveProvider = new BufferedWaveProvider(waveFormat);
            _volumeWaveProvider = new VolumeWaveProvider16(_bufferedWaveProvider);
            _volumeWaveProvider.Volume = Volume;
            var mmDevice = new MMDeviceEnumerator().GetDefaultAudioEndpoint(DataFlow.Render, Role.Multimedia);

            _player = new WasapiOut(mmDevice, AudioClientShareMode.Shared, false, WasapiOutLatency);
            _player.Init(_volumeWaveProvider);
            _player.Play();
        }

        public void AddSamples(byte[] buffer, int offset, int count)
        {
            _bufferedWaveProvider.AddSamples(buffer, offset, count);
        }

        public void Dispose()
        {
            _player?.Stop();
            _player?.Dispose();
            _player = null;
        }

        public void OnCaptureStopped(Exception e)
        {
            Dispose();
        }
    }
}
