﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using Nintendo.Audio.Windows.CoreAudio.Interface;
using System;
using System.Runtime.InteropServices;

namespace Nintendo.Audio.Windows.CoreAudio
{
    public class SpatialAudioObject : IDisposable
    {
        private ISpatialAudioObject _target;

        public bool IsActive
        {
            get
            {
                Marshal.ThrowExceptionForHR(_target.IsActive(out var isActive));
                return isActive != 0;
            }
        }

        public AudioObjectType AudioObjectType
        {
            get
            {
                Marshal.ThrowExceptionForHR(_target.GetAudioObjectType(out var type));
                return type;
            }
        }

        public float Volume
        {
            set { Marshal.ThrowExceptionForHR(_target.SetVolume(value)); }
        }

        public SpatialAudioObject(ISpatialAudioObject target)
        {
            _target = target;
        }

        public void GetBuffer(out IntPtr buffer, out uint bufferLength)
        {
            Marshal.ThrowExceptionForHR(_target.GetBuffer(out var ptr, out var length));
            buffer = ptr;
            bufferLength = length;
        }

        public void SetEndOfStream(uint frameCount)
        {
            Marshal.ThrowExceptionForHR(_target.SetEndOfStream(frameCount));
        }

        public void SetPosition(float x, float y, float z)
        {
            Marshal.ThrowExceptionForHR(_target.SetPosition(x, y, z));
        }

        public void Dispose()
        {
            if (_target != null)
            {
                Marshal.ReleaseComObject(_target);
                _target = null;
            }
        }
    }
}
