﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using Nintendo.Audio.Windows.CoreAudio.Interface;
using System;
using System.Runtime.InteropServices;

namespace Nintendo.Audio.Windows.CoreAudio
{
    public class MMDeviceEnumerator

    {
        private readonly IMMDeviceEnumerator _target = CreateMMDeviceEnumerator();

        public MMDeviceEnumerator()
        {
            if (Environment.OSVersion.Version.Major < 6)
            {
                throw new NotSupportedException();
            }
        }

        public MMDevice GetDefaultAudioEndpoint(DataFlow dataFlow, Role role)
        {
            if (_target == null)
            {
                return null;
            }

            Marshal.ThrowExceptionForHR(_target.GetDefaultAudioEndpoint(dataFlow, role, out var device));
            if (device == null)
            {
                return null;
            }

            return new MMDevice(device);
        }

        private static IMMDeviceEnumerator CreateMMDeviceEnumerator()
        {
            var type = Type.GetTypeFromCLSID(new Guid(CoreAudioGuid.MMDeviceEnumeratorIdText));
            return Activator.CreateInstance(type) as IMMDeviceEnumerator;
        }
    }
}
