﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Runtime.InteropServices;

namespace Nintendo.Audio.Windows.CoreAudio.Interface
{
    [ComImport]
    [Guid(CoreAudioGuid.ISpatialAudioObjectRenderStreamIdText)]
    [InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
    public interface ISpatialAudioObjectRenderStream : ISpatialAudioObjectRenderStreamBase
    {
        [PreserveSig]
        new int GetAvailableDynamicObjectCount(out uint value);

        [PreserveSig]
        new int GetService(ref Guid riid, out IntPtr service);

        [PreserveSig]
        new int Start();

        [PreserveSig]
        new int Stop();

        [PreserveSig]
        new int Reset();

        [PreserveSig]
        new int BeginUpdatingAudioObjects(out uint availableDynamicObjectCount, out uint frameCountPerBuffer);

        [PreserveSig]
        new int EndUpdatingAudioObjects();

        [PreserveSig]
        int ActivateSpatialAudioObject(AudioObjectType type, out ISpatialAudioObject audioObject);
    }
}
