﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Runtime.InteropServices;

namespace Nintendo.Audio.Windows.CoreAudio.Interface
{
    [ComImport]
    [Guid(CoreAudioGuid.ISpatialAudioObjectIdText)]
    [InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
    public interface ISpatialAudioObject : ISpatialAudioObjectBase
    {
        [PreserveSig]
        new int GetBuffer(out IntPtr buffer, out uint bufferLength);

        [PreserveSig]
        new int SetEndOfStream(uint frameCount);

        [PreserveSig]
        new int IsActive(out int isActive);

        [PreserveSig]
        new int GetAudioObjectType(out AudioObjectType type);

        [PreserveSig]
        int SetPosition(float x, float y, float z);

        [PreserveSig]
        int SetVolume(float volume);
    }
}
