﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Runtime.InteropServices;

namespace Nintendo.Audio.Windows.CoreAudio.Interface
{
    [ComImport]
    [Guid(CoreAudioGuid.IAudioClientIdText)]
    [InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
    public interface IAudioClient
    {
        [PreserveSig]
        int Initialize(AudioClientShareMode mode, AudioClientStreamFlags flags, UInt64 duration, UInt64 period, IntPtr format, object guid = null);

        [PreserveSig]
        int GetBufferSize(out UInt32 frameCount);

        [PreserveSig]
        int GetStreamLatency(out UInt64 latency);

        [PreserveSig]
        int GetCurrentPadding(out UInt32 padding);

        [PreserveSig]
        int IsFormatSupported(AudioClientShareMode mode, IntPtr format, [Optional] out IntPtr closestMatch);

        [PreserveSig]
        int GetDevicePeriod(out UInt64 defaultDevicePeriod, out UInt64 minimumDevicePeriod);

        [PreserveSig]
        int Start();

        [PreserveSig]
        int Stop();

        [PreserveSig]
        int Reset();

        [PreserveSig]
        int SetEventHandle(IntPtr handle);

        [PreserveSig]
        int GetService(ref Guid riid, out IntPtr service);
    }
}
