﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;

namespace Nintendo.Audio.Windows.CoreAudio
{
    public static class CoreAudioGuid
    {
        public const string IAudioClientIdText = "1CB9AD4C-DBFA-4c32-B178-C2F568A703B2";
        public const string IAudioFormatEnumeratorIdText = "DCDAA858-895A-4A22-A5EB-67BDA506096D";
        public const string IAudioRenderClientIdText = "F294ACFC-3146-4483-A7BF-ADDCA7C260E2";
        public const string IMMDeviceIdText = "D666063F-1587-4E43-81F1-B948E807363F";
        public const string IMMDeviceCollectionIdText = "0BD7A1BE-7A1A-44DB-8397-CC5392387B5E";
        public const string IMMDeviceEnumeratorIdText = "A95664D2-9614-4F35-A746-DE8DB63617E6";
        public const string ISpatialAudioClientIdText = "BBF8E066-AAAA-49BE-9A4D-FD2A858EA27F";
        public const string ISpatialAudioObjectIdText = "DDE28967-521B-46E5-8F00-BD6F2BC8AB1D";
        public const string ISpatialAudioObjectBaseIdText = "FEAAF403-C1D8-450D-AA05-E0CCEE7502A8";
        public const string ISpatialAudioObjectRenderStreamIdText = "BAB5F473-B423-477B-85F5-B5A332A04153";
        public const string ISpatialAudioObjectRenderStreamBaseIdText = "FEAAF403-C1D8-450D-AA05-E0CCEE7502A8";
        public const string MMDeviceEnumeratorIdText = "BCDE0395-E52F-467C-8E3D-C4579291692E";

        private static readonly Lazy<Guid> ISpatialAudioClientGuid = new Lazy<Guid>(() => new Guid(ISpatialAudioClientIdText));
        private static readonly Lazy<Guid> ISpatialAudioObjectRenderStreamGuid = new Lazy<Guid>(() => new Guid(ISpatialAudioObjectRenderStreamIdText));

        public static Guid ISpatialAudioClientId
        {
            get { return ISpatialAudioClientGuid.Value; }
        }

        public static Guid ISpatialAudioObjectRenderStreamId
        {
            get { return ISpatialAudioObjectRenderStreamGuid.Value; }
        }
    }
}
