﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using Nintendo.Audio.Windows.CoreAudio.Interface;
using System;
using System.Runtime.InteropServices;

namespace Nintendo.Audio.Windows.CoreAudio
{
    public class AudioFormatEnumerator : IDisposable
    {
        private IAudioFormatEnumerator _target;

        public uint Count
        {
            get
            {
                Marshal.ThrowExceptionForHR(_target.GetCount(out var count));
                return count;
            }
        }

        public AudioFormatEnumerator(IAudioFormatEnumerator target)
        {
            _target = target;
        }

        public IntPtr GetFormat(uint index)
        {
            Marshal.ThrowExceptionForHR(_target.GetFormat(index, out var format));
            return format;
        }

        public void Dispose()
        {
            if (_target != null)
            {
                Marshal.ReleaseComObject(_target);
                _target = null;
            }
        }
    }
}
