﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/nn_StaticAssert.h>
#include <cstdlib>
#include <nn/nn_Abort.h>
#include <nn/nn_Log.h>
#include <nn/dbg/dbg_Api.h>
#include <nn/os/os_Argument.h>
#include <nn/nn_SdkLog.h>

typedef int8_t      s8;
typedef uint8_t     u8;
typedef int16_t     s16;
typedef uint16_t    u16;
typedef int32_t     s32;
typedef uint32_t    u32;
typedef int64_t     s64;
typedef uint64_t    u64;

#if DEBUG
#define SNAP_SHOT_DUMPER_TRACE( channel, ... ) NN_SDK_LOG( "[" ); NN_SDK_LOG( channel ); NN_SDK_LOG( "] - " ); NN_SDK_LOG( __VA_ARGS__ ); NN_SDK_LOG( "\n" )
#define SNAP_SHOT_DUMPER_LOG(...) NN_LOG( "[SnapShotDumper] - " ); NN_LOG( __VA_ARGS__ ); NN_LOG( "\n" )
#else
#define SNAP_SHOT_DUMPER_TRACE( channel, ... )
#define SNAP_SHOT_DUMPER_LOG(...)
#endif

#define SNAP_SHOT_DUMPER_EXTENSION ".nxdmp"

enum
{
    //====================================================================
    // This is the size allocated to do memory reads & writes.
    // Tune to taste:  Bigger generally means faster.
    MEMORY_SECTION_BUFFER_SIZE = 0x10000,//0x40000,

};

bool StringsEqual( const char* pStr1, const char* pStr2 );

//====================================================================

