﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <string>
#include <nn/nn_Common.h>

#include "SettingsManager_RapidJson.h"
#include "SettingsManager_TemporaryDatabase.h"

//!< 開発支援機能設定の設定名か否かを表す値を返します。
bool IsSettingNameDebugSettings(const ::std::string& value) NN_NOEXCEPT;

//!< 開発支援機能設定をエクスポートします。
bool ExportDebugSettings(Node* pNode) NN_NOEXCEPT;

//!< 開発支援機能設定をインポートします。
bool ImportDebugSettings(const Node& node) NN_NOEXCEPT;

//!< 開発支援機能設定をダンプします。
bool DumpDebugSettings(TemporaryDatabase* pOutValue) NN_NOEXCEPT;

//!< 開発支援機能設定をロードします。
bool LoadDebugSettings(const TemporaryDatabase& value) NN_NOEXCEPT;
