﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "DevMenuCommand_TimeZone.h"

namespace  devmenuUtil {

namespace {

const TimeZone g_TimeZoneList[] =
{
    { { "UTC" },                    "UTC +00:00" },
    { { "Pacific/Midway" },         "Pacific/Midway UTC -11:00" },
    { { "Pacific/Honolulu" },       "Pacific/Honolulu UTC -10:00" },
    { { "America/Anchorage" },      "America/Anchorage UTC -09:00" },
    { { "America/Tijuana" },        "America/Tijuana UTC -08:00" },
    { { "America/Los_Angeles" },    "America/Los_Angeles,America/Vancouver UTC -08:00" },
    { { "America/Phoenix" },        "America/Phoenix UTC -07:00" },
    { { "America/Denver" },         "America/Denver UTC -07:00" },
    { { "America/Chihuahua" },      "America/Chihuahua UTC -07:00" },
    { { "America/Regina" },         "America/Regina UTC -06:00" },
    { { "America/Mexico_City" },    "America/Mexico_City UTC -06:00" },
    { { "America/Costa_Rica" },     "America/Costa_Rica UTC -06:00" },
    { { "America/Chicago" },        "America/Chicago UTC -06:00" },
    { { "America/New_York" },       "America/New_York,America/Toronto UTC -05:00" },
    { { "America/Bogota" },         "America/Bogota UTC -05:00" },
    { { "America/Caracas" },        "America/Caracas UTC -04:00" },
    { { "America/Manaus" },         "America/Manaus UTC -04:00" },
    { { "America/Halifax" },        "America/Halifax UTC -04:00" },
    { { "America/Barbados" },       "America/Barbados UTC -04:00" },
    { { "America/St_Johns" },       "America/St_Johns UTC -03:30" },
    { { "America/Sao_Paulo" },      "America/Sao_Paulo UTC -03:00" },
    { { "America/Santiago" },       "America/Santiago,America/Recife UTC -03:00" },
    { { "America/Montevideo" },     "America/Montevideo UTC -03:00" },
    { { "America/Godthab" },        "America/Godthab UTC -03:00" },
    { { "America/Buenos_Aires" },   "America/Buenos_Aires UTC -03:00" },
    { { "Atlantic/South_Georgia" }, "Atlantic/South_Georgia UTC -02:00" },
    { { "Atlantic/Cape_Verde" },    "Atlantic/Cape_Verde UTC -01:00" },
    { { "Atlantic/Azores" },        "Atlantic/Azores UTC -01:00" },
    { { "Africa/Casablanca" },      "Africa/Casablanca UTC +00:00" },
    { { "Europe/London" },          "Europe/London,Europe/Lisbon UTC +00:00" },
    { { "Africa/Brazzaville" }, "Africa/Brazzaville UTC +01:00" },
    { { "Africa/Windhoek" }, "Africa/Windhoek UTC +01:00" },
    //{ {"Europe/Amsterdam"},  "UTC +01:00" ) },
    { { "Europe/Belgrade" }, "Europe/Belgrade UTC +01:00" },
    { { "Europe/Berlin" }, "Europe/Berlin,Europe/Rome UTC +01:00" },// "Europe/Berlin,Europe/Rome,Europe/Vienna,Europe/Zurich UTC +01:00" },
    //{ {"Europe/Brussels"},  "UTC +01:00" ) },
    { { "Europe/Madrid" }, "Europe/Madrid,Europe/Paris UTC +01:00" },
    { { "Europe/Sarajevo" }, "Europe/Sarajevo UTC +01:00" },
    { { "Africa/Cairo" }, "Africa/Cairo UTC +02:00" },
    { { "Africa/Harare" }, "Africa/Harare UTC +02:00" },
    { { "Asia/Amman" }, "Asia/Amman UTC +02:00" },
    { { "Asia/Beirut" }, "Asia/Beirut UTC +02:00" },
    { { "Asia/Jerusalem" }, "Asia/Jerusalem UTC +02:00" },
    { { "Europe/Athens" }, "Europe/Athens,Europe/Istanbul UTC +02:00" },
    { { "Europe/Helsinki" }, "Europe/Helsinki UTC +02:00" },
    { { "Africa/Nairobi" }, "Africa/Nairobi UTC +03:00" },
    { { "Asia/Baghdad" }, "Asia/Baghdad UTC +03:00" },
    { { "Asia/Kuwait" }, "Asia/Kuwait UTC +03:00" },
    { { "Europe/Minsk" }, "Europe/Minsk UTC +03:00" },
    { { "Europe/Moscow" }, "Europe/Moscow UTC +03:00" },
    { { "Asia/Tehran" }, "Asia/Tehran UTC +03:30" },
    { { "Asia/Baku" }, "Asia/Baku UTC +04:00" },
    { { "Asia/Dubai" }, "Asia/Dubai UTC +04:00" },
    { { "Asia/Tbilisi" }, "Asia/Tbilisi UTC +04:00" },
    { { "Asia/Yerevan" }, "Asia/Yerevan UTC +04:00" },
    { { "Asia/Kabul" }, "Asia/Kabul UTC +04:30" },
    { { "Asia/Karachi" }, "Asia/Karachi UTC +05:00" },
    { { "Asia/Oral" }, "Asia/Oral UTC +05:00" },
    { { "Asia/Yekaterinburg" }, "Asia/Yekaterinburg UTC +05:00" },
    { { "Asia/Calcutta" }, "Asia/Calcutta UTC +05:30" },
    { { "Asia/Colombo" }, "Asia/Colombo UTC +05:30" },
    { { "Asia/Katmandu" }, "Asia/Katmandu UTC +05:45" },
    { { "Asia/Almaty" }, "Asia/Almaty UTC +06:00" },
    { { "Asia/Rangoon" }, "Asia/Rangoon UTC +06:30" },
    { { "Asia/Bangkok" }, "Asia/Bangkok,Asia/Jakarta UTC +07:00" },
    { { "Asia/Krasnoyarsk" }, "Asia/Krasnoyarsk UTC +07:00" },
    { { "Asia/Irkutsk" }, "Asia/Irkutsk UTC +08:00" },
    { { "Asia/Kuala_Lumpur" }, "Asia/Kuala_Lumpur UTC +08:00" },
    { { "Asia/Shanghai" }, "Asia/Shanghai,Asia/Hong_Kong UTC +08:00" },
    { { "Asia/Taipei" }, "Asia/Taipei UTC +08:00" },
    { { "Australia/Perth" }, "Australia/Perth UTC +08:00" },
    { { "Asia/Seoul" }, "Asia/Seoul UTC +09:00" },
    { { "Asia/Tokyo" }, "Asia/Tokyo UTC +09:00" },
    { { "Asia/Yakutsk" }, "Asia/Yakutsk UTC +09:00" },
    { { "Australia/Adelaide" }, "Australia/Adelaide UTC +09:30" },
    { { "Australia/Darwin" }, "Australia/Darwin UTC +09:30" },
    { { "Asia/Magadan" }, "Asia/Magadan UTC +10:00" },
    { { "Asia/Vladivostok" }, "Asia/Vladivostok UTC +10:00" },
    { { "Australia/Brisbane" }, "Australia/Brisbane UTC +10:00" },
    { { "Australia/Hobart" }, "Australia/Hobart UTC +10:00" },
    { { "Australia/Sydney" }, "Australia/Sydney,Australia/Melbourne UTC +10:00" },
    { { "Pacific/Guam" }, "Pacific/Guam UTC +10:00" },
    { { "Pacific/Noumea" }, "Pacific/Noumea UTC +11:00" },
    { { "Pacific/Auckland" }, "Pacific/Auckland UTC +12:00" },
    { { "Pacific/Fiji" }, "Pacific/Fiji UTC +12:00" },
    { { "Pacific/Majuro" }, "Pacific/Majuro UTC +12:00" },
    { { "Pacific/Tongatapu" }, "Pacific/Tongatapu UTC +13:00" },
};

}

const TimeZone* GetTimeZoneList() NN_NOEXCEPT
{
    return &g_TimeZoneList[0];
}

int GetCountOfTimeZone() NN_NOEXCEPT
{
    return sizeof(g_TimeZoneList) / sizeof(TimeZone);
}

const char* GetTimeZoneDisplayString( const nn::time::LocationName& locationName ) NN_NOEXCEPT
{
    for ( const auto& timeZone: g_TimeZoneList )
    {
        if ( locationName == timeZone.locationName )
        {
            return timeZone.displayString;
        }
    }
    NN_ABORT( "Must not come here(%s)", locationName._value );
}

} // namespace devmenuUtil
