﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Assert.h>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

struct Signature
{
    nn::Bit32   type;
    nn::Bit8    data[60];
    nn::Bit8    padding[64];
};

struct DeviceName
{
    char    prefix[2];
    char    id[16];
    char    delimiter;
    char    variation;
    char    padding[44];
};

struct EciDeviceCertificate
{
    Signature   signature;
    char        publisher[64];
    nn::Bit32   publicKeyType;
    DeviceName  name;
    nn::Bit32   expirationDate;
    nn::Bit8    publicKey[60];
    nn::Bit8    pudding[60];
};
NN_STATIC_ASSERT(sizeof(EciDeviceCertificate) == 384);

nn::Result GetEciDeviceCertificate(EciDeviceCertificate* outValue);
