﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Log.h>
#include <nn/os.h>

class Stopwatch
{
public:
    explicit Stopwatch(bool enabled = true) : m_IsCanceled(!enabled), m_Before(nn::os::GetSystemTick().ToTimeSpan()) {}
    ~Stopwatch()
    {
        if (!m_IsCanceled)
        {
            NN_LOG("[%lld ms]\n", (nn::os::GetSystemTick().ToTimeSpan() - m_Before).GetMilliSeconds());
        }
    }
    void Cancel()
    {
        m_IsCanceled = true;
    }

private:
    bool m_IsCanceled;
    nn::TimeSpan m_Before;
};
