﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "DevMenuCommand_ValueCommand.h"

#include <string>

namespace nn { namespace devmenucommand {

namespace detail {

ProcessResult GetFirmwareDebugSettingsImpl(void* buffer, size_t bufferSize, const std::string& category, const std::string& key) NN_NOEXCEPT;
ProcessResult SetFirmwareDebugSettingsImpl(const void* buffer, size_t bufferSize, const std::string& category, const std::string& key) NN_NOEXCEPT;
ProcessResult GetFirmwareDebugSettingsImpl(std::string* pOut, const std::string& category, const std::string& key) NN_NOEXCEPT;
ProcessResult SetFirmwareDebugSettingsImpl(const std::string& data, const std::string& category, const std::string& key) NN_NOEXCEPT;

} // detail

template <typename T>
inline ProcessResult GetFirmwareDebugSettings(T* pOut, const std::string& category, const std::string& key) NN_NOEXCEPT
{
    return detail::GetFirmwareDebugSettingsImpl(pOut, sizeof(*pOut), category, key);
}

inline ProcessResult GetFirmwareDebugSettings(std::string* pOut, const std::string& category, const std::string& key) NN_NOEXCEPT
{
    return detail::GetFirmwareDebugSettingsImpl(pOut, category, key);
}

inline auto MakeFirmwareDebugSettingsGetter(const std::string& category, const std::string& key) NN_NOEXCEPT
{
    return MakeValueGetter([=](auto* pOut) { return GetFirmwareDebugSettings(pOut, category, key); });
}

template <typename T>
inline ProcessResult SetFirmwareDebugSettings(const T& x, const std::string& category, const std::string& key) NN_NOEXCEPT
{
    return detail::SetFirmwareDebugSettingsImpl(&x, sizeof(x), category, key);
}

inline ProcessResult SetFirmwareDebugSettings(const std::string& x, const std::string& category, const std::string& key) NN_NOEXCEPT
{
    return detail::SetFirmwareDebugSettingsImpl(x, category, key);
}

inline auto MakeFirmwareDebugSettingsSetter(const std::string& category, const std::string& key) NN_NOEXCEPT
{
    return MakeValueSetter([=](const auto& x) { return SetFirmwareDebugSettings(x, category, key); });
}

namespace abbreviation {

inline auto Fwdbg(const std::string& category, const std::string& key) NN_NOEXCEPT
{
    return std::make_tuple(MakeFirmwareDebugSettingsGetter(category, key), MakeFirmwareDebugSettingsSetter(category, key));
}

inline auto Fwdbg(const std::string& keys) NN_NOEXCEPT
{
    auto n = keys.find('/', 0);
    auto category = keys.substr(0, n);
    auto key = keys.substr(n + 1, keys.size() - n - 1);
    return Fwdbg(category, key);
}

}

}}
