﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <string>
#include <nn/nn_Log.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/settings/system/settings_FirmwareVersion.h>

#include "DevMenuCommand_Label.h"
#include "DevMenuCommand_Option.h"

using namespace nn;

namespace
{
    const char HelpMessage[] =
        "usage: " DEVMENUCOMMAND_NAME " firmware version\n"
        "       " DEVMENUCOMMAND_NAME " firmware revision\n"
        "       "
        ""; // 終端

    struct SubCommand
    {
        std::string name;
        Result(*function)(bool* outValue, const Option&);
    };

    Result VersionCommand(bool* outValue, const Option& option)
    {
        NN_UNUSED(option);

        settings::system::FirmwareVersion version;
        settings::system::GetFirmwareVersion(&version);

        NN_LOG("%s\n", version.displayName);

        *outValue = true;
        NN_RESULT_SUCCESS;
    }

    Result RevisionCommand(bool* outValue, const Option& option)
    {
        NN_UNUSED(option);

        settings::system::FirmwareVersion version;
        settings::system::GetFirmwareVersion(&version);

        NN_LOG("%s\n", version.revision );

        *outValue = true;
        NN_RESULT_SUCCESS;
    }

    const SubCommand g_SubCommands[] =
    {
        { "version",    VersionCommand },
        { "revision",   RevisionCommand }
    };
}

Result FirmwareCommand(bool* outValue, const Option& option)
{
    if (!option.HasSubCommand())
    {
        NN_LOG(HelpMessage);
        *outValue = false;
        NN_RESULT_SUCCESS;
    }
    else if (std::string(option.GetSubCommand()) == "--help")
    {
        NN_LOG(HelpMessage);
        *outValue = true;
        NN_RESULT_SUCCESS;
    }

    for (const SubCommand& subCommand : g_SubCommands)
    {
        if (subCommand.name == option.GetSubCommand())
        {
            return subCommand.function(outValue, option);
        }
    }

    NN_LOG("'%s' is not a DevMenu firmware command. See '" DEVMENUCOMMAND_NAME " firmware --help'.\n", option.GetSubCommand());
    *outValue = false;
    NN_RESULT_SUCCESS;
}
