﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nn/os.h>

namespace nn {
namespace wlan {

// メモリの確保とアロケータの初期化を行います。
void InitializeMemory() NN_NOEXCEPT;
// mbufの初期化を行います。
void InitializeMbuf() NN_NOEXCEPT;

// メモリの解放ととアロケータの終了処理を行います。
void FinalizeMemory() NN_NOEXCEPT;
// mbufの終了処理を行います。
void FinalizeMbuf() NN_NOEXCEPT;

// wlan内部で扱うスキャン結果の格納用バッファに対するアロケータ
void* MallocScanBuf(size_t size) NN_NOEXCEPT;
void FreeScanBuf(void* ptr) NN_NOEXCEPT;

}
}

// new,delete,malloc,freeをWLANプロセス用に再定義
void* operator new(size_t size);
void operator delete(void* pv) NN_NOEXCEPT;
void* operator new[](size_t size);
void operator delete[](void* pv) NN_NOEXCEPT;

// WLANプロセス内部で使用するためのmalloc定義
// normalなバッファ領域からmallocするものと、unchachedな領域からmallocするものの2通りを用意
extern "C" void* nnwlanMallocNormal(size_t size);
extern "C" void nnwlanFreeNormal(void* ptr);
extern "C" void* nnwlanMallocUncached(size_t size);
extern "C" void nnwlanFreeUncached(void* ptr);
extern "C" void* nnwlanMallocNormalAligned(int alignment, size_t size);
extern "C" void* nnwlanCallocNormal(size_t num, size_t size);
extern "C" void* nnwlanReallocNormal(void* addr, size_t newSize);
extern "C" size_t nnwlanMallocUsableSize(void* ptr);
extern "C" size_t nnwlanGetTotalFreeSize();

