﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_SdkAssert.h>
#include <nn/sf/sf_Types.h>

#include "wlan_ApiImplBase.h"
#include "../wlan_CommonType.h"
#include "../wlan_StateMachine.h"
#include "../wlan_DebugLog.h"
#include "../../../Libraries/wlan/detail/wlan_IWlanManagers.sfdl.h"

namespace nn { namespace wlan{ namespace server
{
    class LocalApiImpl : public ApiImplBase
    {
    public:
        explicit LocalApiImpl(nn::wlan::StateMachine* pStateMachine) NN_NOEXCEPT
        {
            WLAN_LOG_DEBUG("LocalApiImpl constructor called\n");
            NN_SDK_ASSERT_NOT_NULL(pStateMachine);
            m_pStateMachine = pStateMachine;
        }
        ~LocalApiImpl() NN_NOEXCEPT {}

        // ShimレイヤーAPIの実体
        nn::Result OpenMasterMode() NN_NOEXCEPT;
        nn::Result CloseMasterMode() NN_NOEXCEPT;
        nn::Result OpenClientMode() NN_NOEXCEPT;
        nn::Result CloseClientMode() NN_NOEXCEPT;
        nn::Result OpenSpectatorMode() NN_NOEXCEPT;
        nn::Result CloseSpectatorMode() NN_NOEXCEPT;
        nn::Result CreateBss(const nn::wlan::detail::SfdlMasterBssParameters& bssParameters) NN_NOEXCEPT;
        nn::Result DestroyBss() NN_NOEXCEPT;
        nn::Result StartScan(const nn::wlan::detail::SfdlScanParameters& scanParam) NN_NOEXCEPT;
        nn::Result StopScan() NN_NOEXCEPT;
        nn::Result Connect(const nn::wlan::detail::SfdlSsid& ssid, nn::wlan::detail::SfdlMacAddress bssid, std::int16_t channel,
                const nn::wlan::detail::SfdlSecurity& security, bool autoKeepAlive, std::uint32_t beaconInd, std::int32_t beaconLostTimeout) NN_NOEXCEPT;
        nn::Result CancelConnect() NN_NOEXCEPT;
        nn::Result Join(const nn::wlan::detail::SfdlSsid& ssid, nn::wlan::detail::SfdlMacAddress bssid, std::int16_t channel,
                const nn::wlan::detail::SfdlSecurity& security, std::uint32_t beaconInd, std::int32_t beaconLostTimeout) NN_NOEXCEPT;
        nn::Result CancelJoin() NN_NOEXCEPT;
        nn::Result Disconnect(std::uint32_t mode, const nn::wlan::detail::SfdlDisconnectClient& client) NN_NOEXCEPT;
        nn::Result SetBeaconLostCount(std::uint32_t count) NN_NOEXCEPT;
        nn::Result GetSystemEvent(nn::sf::Out<nn::sf::NativeHandle> pOutSystemEventReadableHandle, std::uint32_t type) NN_NOEXCEPT;
        nn::Result GetConnectionStatus(nn::sf::Out<nn::wlan::detail::SfdlConnectionStatus> pOutStatus) NN_NOEXCEPT;
        nn::Result GetClientStatus(nn::sf::Out<nn::wlan::detail::SfdlClientStatusList> pOutStatusList) NN_NOEXCEPT;
        nn::Result GetBssIndicationEvent(nn::sf::Out<nn::sf::NativeHandle> pOutSystemEventReadableHandle) NN_NOEXCEPT;
        nn::Result GetBssIndicationInfo(nn::sf::Out<nn::wlan::detail::SfdlBssInfo> pOutInfo) NN_NOEXCEPT;
        nn::Result GetAllowedChannels(const nn::sf::OutArray<std::int16_t>& outArray, nn::sf::Out<std::uint32_t> pOutCount) NN_NOEXCEPT;
        nn::Result AddIe(nn::sf::Out<std::uint32_t> pOutIeIndex, std::uint32_t managementFrameType, const nn::sf::InBuffer& pIeBody) NN_NOEXCEPT;
        nn::Result DeleteIe(std::uint32_t ieIndex) NN_NOEXCEPT;
        nn::Result PutFrameRaw(const nn::sf::InBuffer& pTxData) NN_NOEXCEPT;
        nn::Result CancelGetFrame(std::uint32_t rxId) NN_NOEXCEPT;
        nn::Result CreateRxEntry(nn::sf::Out<std::uint32_t> pOutRxId, const nn::sf::InArray<std::uint16_t>& pEthertypeArray, std::uint32_t capacity) NN_NOEXCEPT;
        nn::Result DeleteRxEntry(std::uint32_t rxId) NN_NOEXCEPT;
        nn::Result AddEthertypeToRxEntry(std::uint32_t rxId, std::uint16_t ethertype) NN_NOEXCEPT;
        nn::Result DeleteEthertypeFromRxEntry(nn::sf::Out<std::uint32_t> pOutRxId, std::uint16_t ethertype) NN_NOEXCEPT;
        nn::Result AddMatchingDataToRxEntry(std::uint32_t rxId, const nn::wlan::ReceivedDataMatchInfo& pMatchInfo) NN_NOEXCEPT;
        nn::Result RemoveMatchingDataFromRxEntry(std::uint32_t rxId, const nn::wlan::ReceivedDataMatchInfo& pMatchInfo) NN_NOEXCEPT;
        nn::Result GetScanResult(const nn::sf::OutBuffer& pOutScanBuffer, const nn::wlan::ScanIeMatchInfo& ieInfo) NN_NOEXCEPT;
        nn::Result PutActionFrameOneShot(nn::wlan::detail::SfdlMacAddress macAddr, const nn::sf::InBuffer& pTxData, std::uint32_t channel, std::uint32_t dwellTime) NN_NOEXCEPT;
        nn::Result SetActionFrameWithBeacon(const nn::sf::InBuffer& pTxData) NN_NOEXCEPT;
        nn::Result CancelActionFrameWithBeacon() NN_NOEXCEPT;
        nn::Result CreateRxEntryForActionFrame(nn::sf::Out<std::uint32_t> pOutRxId, const nn::sf::InArray<std::uint16_t>& pSubtypeArray, std::uint32_t capacity) NN_NOEXCEPT;
        nn::Result DeleteRxEntryForActionFrame(std::uint32_t rxId) NN_NOEXCEPT;
        nn::Result AddSubtypeToRxEntryForActionFrame(std::uint32_t rxId, std::uint32_t type) NN_NOEXCEPT;
        nn::Result DeleteSubtypeFromRxEntryForActionFrame(nn::sf::Out<std::uint32_t> pOutRxId, std::uint32_t type) NN_NOEXCEPT;
        nn::Result CancelGetActionFrame(std::uint32_t rxId) NN_NOEXCEPT;
        nn::Result GetRssi(nn::sf::Out<std::int32_t> pOutRssi) NN_NOEXCEPT;
        nn::Result SetMaxAssociationNumber(std::uint32_t maxNum) NN_NOEXCEPT;
        nn::Result OpenLcsMasterMode() NN_NOEXCEPT;
        nn::Result CloseLcsMasterMode() NN_NOEXCEPT;
        nn::Result OpenLcsClientMode() NN_NOEXCEPT;
        nn::Result CloseLcsClientMode() NN_NOEXCEPT;
        nn::Result GetChannelStats(const nn::sf::OutArray<nn::wlan::ChannelStats>& outStats, nn::sf::Out<std::uint32_t> pOutCount) NN_NOEXCEPT;
    }; // end of class LocalApiImpl


    class LocalGetFrameApiImpl : private ApiImplBase
    {
    public:
        explicit LocalGetFrameApiImpl(nn::wlan::StateMachine* pStateMachine) NN_NOEXCEPT
        {
            WLAN_LOG_DEBUG("LocalGetFrameApiImpl constructor called\n");
            NN_SDK_ASSERT_NOT_NULL(pStateMachine);
            m_pStateMachine = pStateMachine;
        }
        ~LocalGetFrameApiImpl() NN_NOEXCEPT {}

        // ShimレイヤーAPIの実体
        nn::Result GetFrameRaw(const nn::sf::OutBuffer& pOutRxData, nn::sf::Out<std::uint32_t> pOutSize, std::uint32_t rxId) NN_NOEXCEPT;
    };

    class LocalGetActionFrameApiImpl : private ApiImplBase
    {
    public:
        explicit LocalGetActionFrameApiImpl(nn::wlan::StateMachine* pStateMachine) NN_NOEXCEPT
        {
            WLAN_LOG_DEBUG("LocalGetActionFrameApiImpl constructor called\n");
            NN_SDK_ASSERT_NOT_NULL(pStateMachine);
            m_pStateMachine = pStateMachine;
        }
        ~LocalGetActionFrameApiImpl() NN_NOEXCEPT {}

        // ShimレイヤーAPIの実体
        nn::Result GetActionFrameCore(nn::sf::Out<nn::wlan::detail::SfdlMacAddress> pOutMacAddr,
                const nn::sf::OutBuffer& pOutRxData, nn::sf::Out<std::uint32_t> pOutSize, std::uint32_t rxId,
                nn::sf::Out<std::uint16_t> channel, nn::sf::Out<std::int16_t> rssi, bool isEx) NN_NOEXCEPT;
    };

}}} // end of namespace nn::wlan::server

