﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_SdkAssert.h>
#include <nn/sf/sf_Types.h>

#include "wlan_ApiImplBase.h"
#include "../wlan_CommonType.h"
#include "../wlan_StateMachine.h"
#include "../wlan_DebugLog.h"
#include "../../../Libraries/wlan/detail/wlan_IWlanManagers.sfdl.h"

namespace nn { namespace wlan{ namespace server
{

    class InfraApiImpl : public ApiImplBase
    {
    public:
        explicit InfraApiImpl(nn::wlan::StateMachine* pStateMachine) NN_NOEXCEPT
        {
            WLAN_LOG_DEBUG("InfraApiImpl constructor called\n");
            NN_SDK_ASSERT_NOT_NULL(pStateMachine);
            m_pStateMachine = pStateMachine;
        }
        ~InfraApiImpl() NN_NOEXCEPT {}
        nn::Result OpenMode() NN_NOEXCEPT;
        nn::Result CloseMode() NN_NOEXCEPT;
        nn::Result StartScan(const nn::wlan::detail::SfdlScanParameters& scanParam) NN_NOEXCEPT;
        nn::Result StopScan() NN_NOEXCEPT;
        nn::Result Connect(const nn::wlan::detail::SfdlSsid& ssid, nn::wlan::detail::SfdlMacAddress bssid, std::int16_t channel,
                const nn::wlan::detail::SfdlSecurity& security, bool autoKeepAlive, std::int32_t beaconLostTimeout) NN_NOEXCEPT;
        nn::Result CancelConnect() NN_NOEXCEPT;
        nn::Result Disconnect() NN_NOEXCEPT;
        nn::Result GetSystemEvent(nn::sf::Out<nn::sf::NativeHandle> pOutSystemEventReadableHandle, std::uint32_t type) NN_NOEXCEPT;
        nn::Result GetConnectionStatus(nn::sf::Out<nn::wlan::detail::SfdlConnectionStatus> pOutStatus) NN_NOEXCEPT;
        nn::Result GetScanResult(const nn::sf::OutBuffer& pOutScanBuffer) NN_NOEXCEPT;
        nn::Result GetRssi(nn::sf::Out<std::int32_t> pOutRssi) NN_NOEXCEPT;
        nn::Result ChangeRxAntenna(std::int32_t rxAntenna) NN_NOEXCEPT;
        nn::Result GetFwVersion(const nn::sf::OutBuffer& pOutBuffer) NN_NOEXCEPT;
        nn::Result RequestSleep() NN_NOEXCEPT;
        nn::Result RequestWakeUp() NN_NOEXCEPT;
        nn::Result ConnectWithWps(std::uint32_t method, const nn::sf::InArray<char>& wpsPinArray, std::int32_t beaconLostTimeout) NN_NOEXCEPT;
        nn::Result GetWakeupReason(nn::sf::Out<std::uint32_t> pOutReason) NN_NOEXCEPT;
        nn::Result SetTcpSessionInformation(nn::wlan::detail::SfdlMacAddress dstMac, nn::wlan::WlanIpv4Address srcIp, nn::wlan::WlanIpv4Address dstIp,
                                            std::uint16_t srcPort, std::uint16_t dstPort, std::uint32_t ackNum, std::uint16_t windowSize) NN_NOEXCEPT;
        nn::Result RemoveTcpSessionInformation() NN_NOEXCEPT;
        nn::Result GetWakeupReasonRaw(nn::sf::Out<std::uint32_t> pOutReason) NN_NOEXCEPT;
        nn::Result SetWakeupReasonRaw(std::uint32_t reason) NN_NOEXCEPT;
        nn::Result EnableWowlFeatures(std::uint32_t features) NN_NOEXCEPT;
        nn::Result GetWowlStats(nn::sf::Out<nn::wlan::WowlWakeCount> pOutCounts, nn::sf::Out<nn::wlan::WowlSleepStats> pOutStats) NN_NOEXCEPT;
        nn::Result ClearWowlStats(bool counts, bool stats) NN_NOEXCEPT;
        nn::Result InitializeWlanOnSkipBoot() NN_NOEXCEPT;
        nn::Result EmulateDriverInitFail() NN_NOEXCEPT;
        nn::Result GetAllowedChannels(const nn::sf::OutArray<std::int16_t>& outArray, nn::sf::Out<std::uint32_t> pOutCount) NN_NOEXCEPT;

    private:
        // （WoWL用）WPA GTK情報登録
        nn::Result SetGtkInfo() NN_NOEXCEPT;
        // （WoWL用）WPA GTK情報クリア
        nn::Result ClearGtkInfo() NN_NOEXCEPT;
#if defined(ENABLE_DETECT_AGING_DEBUG)
        nn::Result OpenDetectModeWithChannel(std::uint16_t channel) NN_NOEXCEPT;
        nn::Result SetDetectRecvConfig(ActionFrameRecvMode mode) NN_NOEXCEPT;
#endif

    }; // end of class SampleApiImpl

}}} // end of namespace nn::wlan::server

