﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>
#include <nn/nn_Common.h>

#include <nn/sf/sf_HipcServer.h>
#include <nn/sf/sf_ObjectFactory.h>

#include "wlan_InfraApiImpl.h"
#include "wlan_LocalApiImpl.h"
#include "wlan_SocketApiImpl.h"
#include "wlan_DetectApiImpl.h"

#include "../wlan_StateMachine.h"
#include "../../../Libraries/wlan/detail/wlan_ServiceName.h"
#include "../../../Libraries/wlan/detail/wlan_IWlanManagers.sfdl.h"

namespace nn { namespace wlan { namespace server {

struct MyServerManagerOption
{
    // ポインタ転送時のバッファサイズ
    static const size_t PointerTransferBufferSize = 4096;
    // サブドメイン内オブジェクト最大数
    static const int ObjectInSubDomainCountMax = 256;
    // サブドメインの最大数
    static const int SubDomainCountMax = 16;
};

// HipcSimpleAllInOneServerManager は HIPC のサーバのポートとセッションを一元管理する。
class HipcServerManager : public nn::sf::HipcSimpleAllInOneServerManager<64, 7, MyServerManagerOption>
{
private:
    InfraApiImpl                m_InfraApiImpl;
    LocalApiImpl                m_LocalApiImpl;
    LocalGetFrameApiImpl        m_LocalGetFrameApiImpl;
    LocalGetActionFrameApiImpl  m_LocalGetActionFrameApiImpl;
    SocketApiImpl               m_SocketApiImpl;
    SocketGetFrameApiImpl       m_SocketGetFrameApiImpl;
    DetectApiImpl               m_DetectApiImpl;
    nn::sf::UnmanagedServiceObjectByPointer<nn::wlan::detail::IInfraManager, InfraApiImpl> m_InfraService;
    nn::sf::UnmanagedServiceObjectByPointer<nn::wlan::detail::ILocalManager, LocalApiImpl> m_LocalService;
    nn::sf::UnmanagedServiceObjectByPointer<nn::wlan::detail::ILocalGetFrame, LocalGetFrameApiImpl> m_LocalGetFrameService;
    nn::sf::UnmanagedServiceObjectByPointer<nn::wlan::detail::ILocalGetActionFrame, LocalGetActionFrameApiImpl> m_LocalGetActionFrameService;
    nn::sf::UnmanagedServiceObjectByPointer<nn::wlan::detail::ISocketManager, SocketApiImpl> m_SocketService;
    nn::sf::UnmanagedServiceObjectByPointer<nn::wlan::detail::ISocketGetFrame, SocketGetFrameApiImpl> m_SocketGetFrameService;
    nn::sf::UnmanagedServiceObjectByPointer<nn::wlan::detail::IDetectManager, DetectApiImpl> m_DetectService;

public:
    explicit HipcServerManager(nn::wlan::StateMachine* pStateMachine) NN_NOEXCEPT;
    virtual ~HipcServerManager() NN_NOEXCEPT;
};

}}}
