﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>

#include "wlan_TestMacro.h"

namespace nn {
namespace wlan {

class TestTxRx
{
public:
    TestTxRx(){};
    ~TestTxRx(){};

    void Initialize();
    void Deinitialize();

    static void BinaryDump(void* data, int len, int type);

    void ToIdle();
    void ToClass1();
    void ToApClass3();

    static void WaitEvent();
    static void SignalEvent();
    static void WaitReceivedEvent();
    static void SignalReceivedEvent();

    void GenerateEtherPacket(uint8_t* buf, int size);
    void ApTestMode();
    void ApTest();
    void StaTest();
    void SendData(uint8_t *dst);

    static int CbFunc_txcompletion(void *buf, int result);
    static int CbFunc_rxdata(void *buf);
    static int CbFunc_rxevent(void *event, void *buf);
    static int CbFunc_wpa_supp_notify(void *ctx, int level, int type, const char *buf, int len);
    static int TxEAPOL(void *buf);
    void RegisterCallback();

    static char * local_wl_ether_etoa(const struct ether_addr *n);
    static void dump_bss_info(void *bi);
};


}
}

