﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Result.h>
#include <nn/os.h>
#include <nn/mbuf/mbuf_Mbuf.h>
#include <nn/nn_Abort.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Log.h>
#include <nn/nn_Assert.h>
//#include <netinet/ether.h>
#include "wlan_Type.h"
#include "wlan_TestBwlApi.h"
#include <dhd_horizon.h>
#include <bwl.h>
#include <wlioctl.h>

#include <proto/bcmevent.h>
#include <proto/802.11.h>
#include <proto/ethernet.h>
#include <bcmutils.h>
//#include <wlu_utils.h>

#include <cstdio>
#include <cstdint>
#include <cstring>
#include <cstdbool>
#include <cwctype>
#include <acsd_horizon.h>
#include <horizon_main.h>
#include <nnc/os/os_MutexApi.h>
#include <nnc/wlan/driver/wlan_DriverTypes.h>

#define MEGA_SIZE    (1024*1024)  //NOLINT(preprocessor/const)
namespace
{
    void * ifh = nullptr;

    nn::os::EventType event;
    nn::os::EventType recvdEvent;
}

namespace nn {
namespace wlan {

    char g_bwl_mega_string[MEGA_SIZE];
    char g_bwl_empty_string[] = "";

    void* bwl_test_param_ptr_values[] =
    {
        nullptr,
#if 0
        (void)(-1),
        (void*)0xCAFEBEEF,
        ptr_to_itf_itself,
#endif
        g_bwl_empty_string,
        g_bwl_mega_string
};
#define BWL_TEST_PARAM_PTR_NUM  \
    (sizeof(bwl_test_param_ptr_values) / sizeof(bwl_test_param_ptr_values[0]))

/* Values for WLAN_PARAM_NUMBER */
uint64_t bwl_test_param_number_values[] =
{
    (0),
    (1),
    0x00000000000000FF,
    0x000000000000FFFF,
    0x00000000FFFFFFFF,
    0xFFFFFFFFFFFFFFFF,
    (uint64_t)g_bwl_empty_string,
    (uint64_t)g_bwl_mega_string
};
#define BWL_TEST_PARAM_NUMBER_NUM  \
    (sizeof(bwl_test_param_number_values) / sizeof(bwl_test_param_number_values[0]))

/* Values for WLAN_PARAM_ETHER_ADDR_PTR */
struct ether_addr bwl_test_param_ether_addr_values[] =
{
    {.octet = {0, 0, 0, 0, 0, 0}},
    {.octet = {0xff, 0xff, 0xff, 0xff, 0xff, 0xff}},
};
#define BWL_TEST_PARAM_ETHER_ADDR_NUM \
    (sizeof(bwl_test_param_ether_addr_values) / sizeof(bwl_test_param_ether_addr_values[0]))

/* Values for WLAN_PARAM_MACLIST_PTR */
#define BWL_TEST_PARAM_MACLIST_NUM (3)  //NOLINT(preprocessor/const)
struct maclist* bwl_test_param_maclist_values[BWL_TEST_PARAM_MACLIST_NUM];

/* Array indexing the number of possible parameters for a given type. */
int parameter_type_number[WLAN_PARAM_END] =
{
    1, //WLAN_PARAM_NONE
    1, //WLAN_PARAM_ITF // FIXME
    BWL_TEST_PARAM_NUMBER_NUM,    //WLAN_PARAM_NUMBER
    BWL_TEST_PARAM_PTR_NUM,       //WLAN_PARAM_PTR
    /* FIXME Consider all pointers as pointers. */
    BWL_TEST_PARAM_PTR_NUM + BWL_TEST_PARAM_ETHER_ADDR_NUM, //WLAN_PARAM_ETHER_ADDR_PTR
    BWL_TEST_PARAM_PTR_NUM + BWL_TEST_PARAM_MACLIST_NUM, //WLAN_PARAM_MACLIST_PTR
    BWL_TEST_PARAM_PTR_NUM, //WLAN_PARAMETER_BWL_RATE_INFO_PTR
    BWL_TEST_PARAM_PTR_NUM, //WLAN_PARAMETER_NSC_SCAN_RESULTS_PTR
    BWL_TEST_PARAM_PTR_NUM, //WLAN_PARAMETER_NSC_SCAN_DES_PTR
    BWL_TEST_PARAM_PTR_NUM, //WLAN_PARAMETER_NSC_SSID_LIST_PTR
    BWL_TEST_PARAM_PTR_NUM, //WLAN_PARAMETER_SSID_LIST_PTR
    BWL_TEST_PARAM_PTR_NUM, //WLAN_PARAMETER_COUNTRY_PTR
    BWL_TEST_PARAM_PTR_NUM, //WLAN_PARAMETER_PM2_SLEEP_PTR
    BWL_TEST_PARAM_PTR_NUM, //WLAN_PARAMETER_RATESET_PTR
    BWL_TEST_PARAM_PTR_NUM, //WLAN_PARAMETER_SCB_PROBE_PTR
};

wlan_test_fn_descriptor_t func_array[] =
{
    {    "bwl_set_apmode",
        (fn_12_t)bwl_set_apmode,
        2,
        {WLAN_PARAM_ITF, WLAN_PARAM_NUMBER, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE}
    },
    {    "bwl_get_apmode",
        (fn_12_t)bwl_get_apmode,
        2,
        {WLAN_PARAM_ITF, WLAN_PARAM_PTR, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE}
    },
    {    "bwl_set_inframode",
        (fn_12_t)bwl_set_inframode,
        2,
        {WLAN_PARAM_ITF, WLAN_PARAM_NUMBER, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE}
    },
    {    "bwl_set_channel",
        (fn_12_t)bwl_set_channel,
        2,
        {WLAN_PARAM_ITF,  WLAN_PARAM_NUMBER, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE}
    },
    {    "bwl_get_inframode",
        (fn_12_t)bwl_get_inframode,
        2,
        {WLAN_PARAM_ITF,  WLAN_PARAM_PTR, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE}
    },
    {    "bwl_get_channel",
        (fn_12_t)bwl_get_channel,
        2,
        {WLAN_PARAM_ITF,  WLAN_PARAM_PTR, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE}
    },
    {    "bwl_isup",
        (fn_12_t)bwl_isup,
        2,
        {WLAN_PARAM_ITF,  WLAN_PARAM_PTR, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE}
    },
    {    "bwl_set_band",
        (fn_12_t)bwl_set_band,
        2,
        {WLAN_PARAM_ITF,  WLAN_PARAM_NUMBER, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE}
    },
    {    "bwl_set_wsec",
        (fn_12_t)bwl_set_wsec,
        2,
        {WLAN_PARAM_ITF,  WLAN_PARAM_NUMBER, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE}
    },
    {    "bwl_set_mpc",
        (fn_12_t)bwl_set_mpc,
        2,
        {WLAN_PARAM_ITF,  WLAN_PARAM_NUMBER, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE}
    },
    {    "bwl_set_pm",
        (fn_12_t)bwl_set_pm,
        2,
        {WLAN_PARAM_ITF,  WLAN_PARAM_NUMBER, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE}
    },
    {    "bwl_set_vhtmode",
        (fn_12_t)bwl_set_vhtmode,
        2,
        {WLAN_PARAM_ITF,  WLAN_PARAM_NUMBER, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE}
    },
    {    "bwl_add_afsubtype",
        (fn_12_t)bwl_add_afsubtype,
        2,
        {WLAN_PARAM_ITF,  WLAN_PARAM_NUMBER, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE}
    },
    {    "bwl_set_ds3mode",
        (fn_12_t)bwl_set_ds3mode,
        2,
        {WLAN_PARAM_ITF,  WLAN_PARAM_NUMBER, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE}
    },
    {    "bwl_get_ds3mode",
        (fn_12_t)bwl_get_ds3mode,
        2,
        {WLAN_PARAM_ITF,  WLAN_PARAM_PTR, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE}
    },
    {    "bwl_set_bcnlossthresh",
        (fn_12_t)bwl_set_bcnlossthresh,
        2,
        {WLAN_PARAM_ITF,  WLAN_PARAM_NUMBER, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE}
    },
    {    "bwl_get_bcnlossthresh",
        (fn_12_t)bwl_get_bcnlossthresh,
        2,
        {WLAN_PARAM_ITF,  WLAN_PARAM_PTR, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE}
    },
    {    "bwl_set_eventmask",
        (fn_12_t)bwl_set_eventmask,
        2,
        {WLAN_PARAM_ITF,  WLAN_PARAM_PTR, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE}
    },
    {    "bwl_get_eventmask",
        (fn_12_t)bwl_get_eventmask,
        2,
        {WLAN_PARAM_ITF,  WLAN_PARAM_PTR, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE}
    },
    {    "bwl_set_keepalive",
        (fn_12_t)bwl_set_keepalive,
        2,
        {WLAN_PARAM_ITF,  WLAN_PARAM_NUMBER, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE}
    },
    {    "bwl_set_peakrate",
        (fn_12_t)bwl_set_peakrate,
        2,
        {WLAN_PARAM_ITF,  WLAN_PARAM_PTR, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE}
    },
    {    "bwl_get_peakrate",
        (fn_12_t)bwl_get_peakrate,
        2,
        {WLAN_PARAM_ITF,  WLAN_PARAM_PTR, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE}
    },
    {    "bwl_static_aesmode",
        (fn_12_t)bwl_static_aesmode,
        2,
        {WLAN_PARAM_ITF,  WLAN_PARAM_NUMBER, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE}
    },
    {    "bwl_txpkt",
        (fn_12_t)bwl_txpkt,
        2,
        {WLAN_PARAM_ITF,  WLAN_PARAM_PTR, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE}
    },
    {    "bwl_radio_tune_onoff",
        (fn_12_t)bwl_radio_tune_onoff,
        2,
        {WLAN_PARAM_ITF,  WLAN_PARAM_NUMBER, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE}
    },
    {    "bwl_wowl_activate",
        (fn_12_t)bwl_wowl_activate,
        2,
        {WLAN_PARAM_ITF,  WLAN_PARAM_PTR, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE}
    },
    {    "bwl_create",
        (fn_12_t)bwl_create,
        3,
        {WLAN_PARAM_ITF,  WLAN_PARAM_PTR,  WLAN_PARAM_NUMBER, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE}
    },
    {    "bwl_ver",
        (fn_12_t)bwl_ver,
        3,
        {WLAN_PARAM_ITF,  WLAN_PARAM_PTR,  WLAN_PARAM_NUMBER, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE}
    },
    {    "bwl_btc_restage_rxgain",
        (fn_12_t)bwl_btc_restage_rxgain,
        3,
        {WLAN_PARAM_ITF,  WLAN_PARAM_PTR,  WLAN_PARAM_NUMBER, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE}
    },
    {    "bwl_nsc_approval_tmo",
        (fn_12_t)bwl_nsc_approval_tmo,
        3,
        {WLAN_PARAM_ITF,  WLAN_PARAM_PTR,  WLAN_PARAM_NUMBER, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE}
    },
    {    "bwl_wowl",
        (fn_12_t)bwl_wowl,
        3,
        {WLAN_PARAM_ITF,  WLAN_PARAM_PTR,  WLAN_PARAM_NUMBER, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE}
    },
    {    "bwl_get_afsubtypelist",
        (fn_12_t)bwl_get_afsubtypelist,
        3,
        {WLAN_PARAM_ITF,  WLAN_PARAM_PTR,  WLAN_PARAM_NUMBER, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE}
    },
    {    "bwl_get_assocstatus",
        (fn_12_t)bwl_get_assocstatus,
        4,
        {WLAN_PARAM_ITF,  WLAN_PARAM_PTR,  WLAN_PARAM_NUMBER,  WLAN_PARAM_PTR,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE}
    },
    {    "bwl_join",
        (fn_12_t)bwl_join,
        4,
        {WLAN_PARAM_ITF,  WLAN_PARAM_PTR,  WLAN_PARAM_NUMBER,  WLAN_PARAM_NUMBER,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE}
    },
    {    "bwl_nsc_scanpatt",
        (fn_12_t)bwl_nsc_scanpatt,
        4,
        {WLAN_PARAM_ITF,  WLAN_PARAM_PTR,  WLAN_PARAM_PTR,  WLAN_PARAM_NUMBER,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE}
    },
    {    "bwl_nsc_afdata",
        (fn_12_t)bwl_nsc_afdata,
        4,
        {WLAN_PARAM_ITF,  WLAN_PARAM_PTR,  WLAN_PARAM_PTR,  WLAN_PARAM_NUMBER,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE}
    },
    {    "bwl_nsc_usdwtimes",
        (fn_12_t)bwl_nsc_usdwtimes,
        4,
        {WLAN_PARAM_ITF,  WLAN_PARAM_PTR,  WLAN_PARAM_PTR,  WLAN_PARAM_NUMBER,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE}
    },
    {    "bwl_wowl_wakeind",
        (fn_12_t)bwl_wowl_wakeind,
        4,
        {WLAN_PARAM_ITF,  WLAN_PARAM_NUMBER,  WLAN_PARAM_PTR,  WLAN_PARAM_PTR,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE}
    },
    {    "bwl_nsc_subtypeoui",
        (fn_12_t)bwl_nsc_subtypeoui,
        4,
        {WLAN_PARAM_ITF,  WLAN_PARAM_PTR,  WLAN_PARAM_NUMBER,  WLAN_PARAM_NUMBER,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE}
    },
    {    "bwl_add_ie",
        (fn_12_t)bwl_add_ie,
        5,
        {WLAN_PARAM_ITF,  WLAN_PARAM_NUMBER,  WLAN_PARAM_PTR,  WLAN_PARAM_PTR,
        WLAN_PARAM_NUMBER, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE}
    },
    {    "bwl_del_ie",
        (fn_12_t)bwl_del_ie,
        5,
        {WLAN_PARAM_ITF,  WLAN_PARAM_NUMBER,  WLAN_PARAM_PTR,  WLAN_PARAM_PTR,
        WLAN_PARAM_NUMBER, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE}
    },
    {    "bwl_wowl_pattern",
        (fn_12_t)bwl_wowl_pattern,
        7,
        {WLAN_PARAM_ITF,  WLAN_PARAM_PTR,  WLAN_PARAM_NUMBER,  WLAN_PARAM_PTR,
        WLAN_PARAM_PTR,  WLAN_PARAM_PTR,  WLAN_PARAM_NUMBER, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE}
    },
    {    "bwl_wowl_pattern_rawmask",
        (fn_12_t)bwl_wowl_pattern_rawmask,
        7,
        {WLAN_PARAM_ITF,  WLAN_PARAM_PTR,  WLAN_PARAM_NUMBER,  WLAN_PARAM_PTR,
        WLAN_PARAM_PTR,  WLAN_PARAM_PTR,  WLAN_PARAM_NUMBER, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE}
    },
    /* TODO Functions taking a structure as a parameter. The field settings is TDB*/
    {    "bwl_set_pm2_sleep_ret_ext",
        (fn_12_t)bwl_set_pm2_sleep_ret_ext,
        2,
        {WLAN_PARAM_ITF, WLAN_PARAMETER_PM2_SLEEP_PTR, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE}
    },
    {    "bwl_get_curetheraddr",
        (fn_12_t)bwl_get_curetheraddr,
        2,
        {WLAN_PARAM_ITF, WLAN_PARAM_ETHER_ADDR_PTR, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE}
    },
    {    "bwl_set_curetheraddr",
        (fn_12_t)bwl_set_curetheraddr,
        2,
        {WLAN_PARAM_ITF, WLAN_PARAM_ETHER_ADDR_PTR, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE}
    },
    {    "bwl_set_activity_time",
        (fn_12_t)bwl_set_activity_time,
        2,
        {WLAN_PARAM_ITF, WLAN_PARAMETER_SCB_PROBE_PTR, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE}
    },
    {    "bwl_get_activity_time",
        (fn_12_t)bwl_get_activity_time,
        2,
        {WLAN_PARAM_ITF, WLAN_PARAMETER_SCB_PROBE_PTR, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE}
    },
    {    "bwl_set_rateset",
        (fn_12_t)bwl_set_rateset,
        2,
        {WLAN_PARAM_ITF, WLAN_PARAMETER_RATESET_PTR, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE}
    },
    {    "bwl_get_rateset",
        (fn_12_t)bwl_get_rateset,
        2,
        {WLAN_PARAM_ITF, WLAN_PARAMETER_RATESET_PTR, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE}
    },
    {    "bwl_get_rateset_exdef",
        (fn_12_t)bwl_get_rateset_exdef,
        2,
        {WLAN_PARAM_ITF, WLAN_PARAMETER_RATESET_PTR, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE}
    },
    {    "bwl_nsc_results",
        (fn_12_t)bwl_nsc_results,
        2,
        {WLAN_PARAM_ITF, WLAN_PARAMETER_NSC_SCAN_RESULTS_PTR, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE}
    },
    {    "bwl_deauth",
        (fn_12_t)bwl_deauth,
        3,
        {WLAN_PARAM_ITF, WLAN_PARAM_ETHER_ADDR_PTR, WLAN_PARAM_NUMBER, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE}
    },
    {    "bwl_get_assoclist",
        (fn_12_t)bwl_get_assoclist,
        3,
        {WLAN_PARAM_ITF, WLAN_PARAM_ETHER_ADDR_PTR, WLAN_PARAM_PTR, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE}
    },
    {    "bwl_nsc_tgtssid",
        (fn_12_t)bwl_nsc_tgtssid,
        3,
        {WLAN_PARAM_ITF, WLAN_PARAMETER_NSC_SSID_LIST_PTR, WLAN_PARAM_NUMBER, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE}
    },
    {    "bwl_nsc_scandescr",
        (fn_12_t)bwl_nsc_scandescr,
        3,
        {WLAN_PARAM_ITF, WLAN_PARAMETER_NSC_SCAN_DES_PTR, WLAN_PARAM_NUMBER, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE}
    },
    {    "bwl_nsc_spmac",
        (fn_12_t)bwl_nsc_spmac,
        3,
        {WLAN_PARAM_ITF, WLAN_PARAM_MACLIST_PTR, WLAN_PARAM_NUMBER, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE}
    },
    {    "bwl_country",
        (fn_12_t)bwl_country,
        3,
        {WLAN_PARAM_ITF, WLAN_PARAMETER_COUNTRY_PTR, WLAN_PARAM_NUMBER, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE}
    },
    {    "bwl_setaeskey",
        (fn_12_t)bwl_setaeskey,
        4,
        {WLAN_PARAM_ITF, WLAN_PARAM_NUMBER, WLAN_PARAM_PTR, WLAN_PARAM_ETHER_ADDR_PTR,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE}
    },
    {    "bwl_set_fixedrate",
        (fn_12_t)bwl_set_fixedrate,
        5,
        {WLAN_PARAM_ITF, WLAN_PARAM_NUMBER, WLAN_PARAM_NUMBER, WLAN_PARAM_NUMBER,
        WLAN_PARAMETER_BWL_RATE_INFO_PTR, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE}
    },
    {    "bwl_get_fixedrate",
        (fn_12_t)bwl_get_fixedrate,
        5,
        {WLAN_PARAM_ITF, WLAN_PARAM_NUMBER, WLAN_PARAM_NUMBER, WLAN_PARAM_NUMBER,
        WLAN_PARAMETER_BWL_RATE_INFO_PTR, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE}
    },
    {    "bwl_send_periodic_af",
        (fn_12_t)bwl_send_periodic_af,
        5,
        {WLAN_PARAM_ITF, WLAN_PARAM_PTR, WLAN_PARAM_NUMBER, WLAN_PARAM_ETHER_ADDR_PTR,
        WLAN_PARAM_ETHER_ADDR_PTR, WLAN_PARAM_NUMBER, WLAN_PARAM_NUMBER, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE}
    },
    {    "bwl_send_one_af",
        (fn_12_t)bwl_send_one_af,
        5,
        {WLAN_PARAM_ITF, WLAN_PARAM_PTR, WLAN_PARAM_NUMBER, WLAN_PARAM_ETHER_ADDR_PTR,
        WLAN_PARAM_ETHER_ADDR_PTR, WLAN_PARAM_NUMBER, WLAN_PARAM_NUMBER, WLAN_PARAM_NONE,
        WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE, WLAN_PARAM_NONE}
    },
    {    "bwl_advscan",
        (fn_12_t)bwl_advscan,
        5,
        {WLAN_PARAM_ITF, WLAN_PARAMETER_SSID_LIST_PTR, WLAN_PARAM_NUMBER, WLAN_PARAM_ETHER_ADDR_PTR,
        WLAN_PARAM_NUMBER, WLAN_PARAM_NUMBER, WLAN_PARAM_NUMBER, WLAN_PARAM_NUMBER, WLAN_PARAM_NUMBER,
        WLAN_PARAM_NUMBER, WLAN_PARAM_NUMBER, WLAN_PARAM_NONE}
    },
};

#define BWL_TEST_FN_NUM  \
    (sizeof(func_array) / sizeof(func_array[0]))

#define TEST_ENTER()    NN_LOG(">>>> Enter %s <<<<\n", __FUNCTION__)
#define TEST_LEAVE()    NN_LOG("    <<<< Leave %s <<<<\n", __FUNCTION__)

void TestBwlApi::Initialize()
{
    TEST_ENTER();
    nn::os::InitializeEvent( &event, false, nn::os::EventClearMode_AutoClear );
    nn::os::InitializeEvent( &recvdEvent, false, nn::os::EventClearMode_AutoClear );
    bwl_dhd_initialize(&ifh);
    RegisterCallback();
    TEST_LEAVE();
}

void TestBwlApi::Deinitialize()
{
    TEST_ENTER();
    bwl_dhd_deinitialize(ifh);
    ifh = nullptr;
    nn::os::FinalizeEvent( &event );
    nn::os::FinalizeEvent( &recvdEvent );
    TEST_LEAVE();
}

int TestBwlApi::CbFunc_txcompletion(void *buf , int result)
{
    nn::mbuf::MbufFreem(reinterpret_cast<nn::mbuf::Mbuf *>(buf));
    return 0;
}

int TestBwlApi::CbFunc_rxdata(void *buf)
{
    return 0;
}

int TestBwlApi::CbFunc_rxevent(void *event, void *buf)
{
    nn::mbuf::MbufFreem(reinterpret_cast<nn::mbuf::Mbuf *>(buf));
    return 0;
}

void TestBwlApi::RegisterCallback()
{
    dhd_register_txcompletion_cb(ifh, &CbFunc_txcompletion);
    dhd_register_rxdata_cb(ifh, &CbFunc_rxdata);
    dhd_register_event_cb(ifh, &CbFunc_rxevent);

}

uint64_t TestBwlApi::GetParam(wlan_test_parameter_type type, int index)
{
    uint64_t result = 0;
    switch (type)
    {
        case WLAN_PARAM_NUMBER:
            result = bwl_test_param_number_values[index];
            break;

        case WLAN_PARAM_PTR:
        /* FIXME get proper behaviour for those settings. */
        case WLAN_PARAMETER_BWL_RATE_INFO_PTR:
        case WLAN_PARAMETER_NSC_SCAN_RESULTS_PTR:
        case WLAN_PARAMETER_NSC_SCAN_DES_PTR:
        case WLAN_PARAMETER_NSC_SSID_LIST_PTR:
        case WLAN_PARAMETER_SSID_LIST_PTR:
        case WLAN_PARAMETER_COUNTRY_PTR:
        case WLAN_PARAMETER_PM2_SLEEP_PTR:
        case WLAN_PARAMETER_RATESET_PTR:
        case WLAN_PARAMETER_SCB_PROBE_PTR:
            result = (uint64_t)(bwl_test_param_ptr_values[index]);
            break;

        case WLAN_PARAM_ETHER_ADDR_PTR:
            if (index < BWL_TEST_PARAM_PTR_NUM) {
                result = (uint64_t)(bwl_test_param_ptr_values[index]);
            } else {
                /* Use example structure */
                int j = index - BWL_TEST_PARAM_PTR_NUM;
                result = (uint64_t)&(bwl_test_param_ether_addr_values[j]);
            }
            break;

        case WLAN_PARAM_MACLIST_PTR:
            if (index < BWL_TEST_PARAM_PTR_NUM) {
                result = (uint64_t)(bwl_test_param_ptr_values[index]);
            } else {
                /* Use example structure */
                int j = index - BWL_TEST_PARAM_PTR_NUM;
                result = (uint64_t)(bwl_test_param_maclist_values[j]);
            }
            break;

        case WLAN_PARAM_ITF:
            result = (uint64_t)ifh;
            break;

        case WLAN_PARAM_NONE:
        default:
            result = 0;
    }

    return result;
}

/** TODO Test intialization 1.3.6.7.1 */
int TestBwlApi::InitTest()
{
    void *fake_ifh;
    int i;
    TEST_ENTER();
    NN_LOG("bwl_dhd_initialize(nullptr)\n");
    bwl_dhd_initialize(nullptr);


    NN_LOG("bwl_dhd_initialize() called a second time\n");
    Initialize();
    for (i=0; i < 10000000; i++) {
        if (i % 1000 == 0) {
            NN_LOG("%dth bwl_dhd_initialize() call\n", i + 1);
        }
        bwl_dhd_initialize(&fake_ifh);
    }
    Deinitialize();

    TEST_LEAVE();
    return 0;
}

/** Test deinitialization 1.3.6.7.2 */
int TestBwlApi::DeinitTest()
{
    void *fake_ifh;
    int i;
    TEST_ENTER();
    NN_LOG("bwl_dhd_deinitialize(nullptr) without previous init.\n");
    bwl_dhd_deinitialize(nullptr);


    NN_LOG("bwl_dhd_deinitialize(nullptr).\n");
    Initialize();
    bwl_dhd_deinitialize(nullptr);
    Deinitialize();


    NN_LOG("bwl_dhd_deinitialize() called a second time.\n");
    Initialize();
    for (i=0; i < 10000000; i++) {
        if (i % 1000 == 0) {
            NN_LOG("%dth bwl_dhd_deinitialize() call\n", i + 1);
        }
        bwl_dhd_deinitialize(ifh);
    }
    Deinitialize();

    TEST_LEAVE();
    return 0;
}

/** Test interface parameter  1.3.6.7.3 */
int TestBwlApi::InterfaceNullTest()
{
    int fn_idx = 0;
    TEST_ENTER();
    Initialize();

    NN_LOG("Test robustness when only parameter is IFH pointer\n");
    NN_LOG("bwl_dhd_del_all_sta_force(nullptr)\n");
            bwl_dhd_del_all_sta_force(nullptr);
    NN_LOG("bwl_enable_mc2(nullptr)\n");
            bwl_enable_mc2(nullptr);
    NN_LOG("bwl_disable_mc2(nullptr)\n");
            bwl_disable_mc2(nullptr);
    NN_LOG("bwl_reset(nullptr)\n");
            bwl_reset(nullptr);
    NN_LOG("bwl_up(nullptr)\n");
            bwl_up(nullptr);
    NN_LOG("bwl_down(nullptr)\n");
            bwl_down(nullptr);
    NN_LOG("bwl_disassoc(nullptr)\n");
            bwl_disassoc(nullptr);
    NN_LOG("bwl_get_pm2_sleep_ret_ext(nullptr)\n");
            bwl_get_pm2_sleep_ret_ext(nullptr);
    NN_LOG("bwl_advscan_abort(nullptr)\n");
            bwl_advscan_abort(nullptr);
    NN_LOG("bwl_cancel_periodic_af(nullptr)\n");
            bwl_cancel_periodic_af(nullptr);
    NN_LOG("bwl_clear_afsubtypes(nullptr)\n");
            bwl_clear_afsubtypes(nullptr);
    NN_LOG("bwl_wowl_clear(nullptr)\n");
            bwl_wowl_clear(nullptr);
    NN_LOG("dhd_start_xmit(nullptr)\n");
            dhd_start_xmit(nullptr);

    NN_LOG("Test robustness of function with parameters\n");
    for (fn_idx = 0; fn_idx < BWL_TEST_FN_NUM; fn_idx++) {
        CheckFunc(fn_idx, nullptr);
    }

    Deinitialize();
    TEST_LEAVE();
    return 0;
}

/** Test one function from the func_array, based on the given index. */
int TestBwlApi::CheckFunc(int fn_idx, void* ifh)
{
    /* XXX Ignore p0 (ifh/wl) for now */
    int p1 = 0;
    int p2 = 0;
    int p3 = 0;
    int p4 = 0;
    int p5 = 0;
    int p6 = 0;
    int p7 = 0;
    int p8 = 0;
    int p9 = 0;
    int p10 = 0;
    int p11 = 0;

    for (p1 = 0; p1 < parameter_type_number[func_array[fn_idx].params[1]]; p1++) {
     for (p2 = 0; p2 < parameter_type_number[func_array[fn_idx].params[2]]; p2++) {
      for (p3 = 0; p3 < parameter_type_number[func_array[fn_idx].params[3]]; p3++) {
       for (p4 = 0; p4 < parameter_type_number[func_array[fn_idx].params[4]]; p4++) {
        for (p5 = 0; p5 < parameter_type_number[func_array[fn_idx].params[5]]; p5++) {
         for (p6 = 0; p6 < parameter_type_number[func_array[fn_idx].params[6]]; p6++) {
          for (p7 = 0; p7 < parameter_type_number[func_array[fn_idx].params[7]]; p7++) {
           for (p8 = 0; p8 < parameter_type_number[func_array[fn_idx].params[8]]; p8++) {
            for (p9 = 0; p9 < parameter_type_number[func_array[fn_idx].params[9]]; p9++) {
             for (p10 = 0; p10 < parameter_type_number[func_array[fn_idx].params[10]]; p10++) {
              for (p11 = 0; p11 < parameter_type_number[func_array[fn_idx].params[11]]; p11++) {
                NN_LOG("Testing: %s(ifh, %lx, %lx, %lx, %lx, %lx, %lx, "
                    "%lx, %lx, %lx, %lx, %lx)\n",
                    func_array[fn_idx].name,
                    GetParam(func_array[fn_idx].params[1], p1),
                    GetParam(func_array[fn_idx].params[2], p2),
                    GetParam(func_array[fn_idx].params[3], p3),
                    GetParam(func_array[fn_idx].params[4], p4),
                    GetParam(func_array[fn_idx].params[5], p5),
                    GetParam(func_array[fn_idx].params[6], p6),
                    GetParam(func_array[fn_idx].params[7], p7),
                    GetParam(func_array[fn_idx].params[8], p8),
                    GetParam(func_array[fn_idx].params[9], p9),
                    GetParam(func_array[fn_idx].params[10], p10),
                    GetParam(func_array[fn_idx].params[11], p11));
                /* Actual call */
                (func_array[fn_idx].fn)(ifh,
                    GetParam(func_array[fn_idx].params[1], p1),
                    GetParam(func_array[fn_idx].params[2], p2),
                    GetParam(func_array[fn_idx].params[3], p3),
                    GetParam(func_array[fn_idx].params[4], p4),
                    GetParam(func_array[fn_idx].params[5], p5),
                    GetParam(func_array[fn_idx].params[6], p6),
                    GetParam(func_array[fn_idx].params[7], p7),
                    GetParam(func_array[fn_idx].params[8], p8),
                    GetParam(func_array[fn_idx].params[9], p9),
                    GetParam(func_array[fn_idx].params[10], p10),
                    GetParam(func_array[fn_idx].params[11], p11));
              }
             }
            }
           }
          }
         }
        }
       }
      }
     }
    }
    return 0;
}


/** Test BWL API with BWL inited 1.3.6.7.4 */
int TestBwlApi::InitedApiTest()
{
    int fn_idx = 0;
    int i = 0;
    int param_ids[WLAN_TEST_MAX_PARAMS];

    TEST_ENTER();
    Initialize();

    for (fn_idx = 0; fn_idx < BWL_TEST_FN_NUM; fn_idx++) {
        CheckFunc(fn_idx, ifh);
    }

    Deinitialize();
    TEST_LEAVE();
    return 0;
}

/** TODO Test BWL API while deintialized 1.3.6.7.5 */
int TestBwlApi::DeinitedApiTest()
{
    int fn_idx = 0;
    int i = 0;
    int param_ids[WLAN_TEST_MAX_PARAMS];

    TEST_ENTER();

    for (fn_idx = 0; fn_idx < BWL_TEST_FN_NUM; fn_idx++) {
        CheckFunc(fn_idx, ifh);
    }

    TEST_LEAVE();
    return 0;
}

/** TODO Test function with structure parameters 1.3.6.7.6 */
int TestBwlApi::InitedApiWithStructTest()
{
    NN_LOG("TODO: Implement %s\n", __FUNCTION__);
    return 0;
}

/** TODO Test function with structure parameters while BWL
 * is not initialized intialization 1.3.6.7.7 */
int TestBwlApi::DeinitedApiWithStructTest()
{
    NN_LOG("TODO: Implement %s\n", __FUNCTION__);
    return 0;
}

/** FIXME Test ACSD APIs 1.3.6.7.8 */
int TestBwlApi::Acsd()
{
    NN_LOG("TODO: Implement %s\n", __FUNCTION__);
    return 0;
}

/** FIXME Test Wpa_Supplicant APIs. 1.3.6.7.9 */
int TestBwlApi::WpaSupplicant()
{
    NN_LOG("TODO: Implement %s\n", __FUNCTION__);
    return 0;
}

TestBwlApi::TestBwlApi()
{
    int i = 0;
    /* TODO: Randomize the content of the mega buffer */
    /* WLAN_PARAM_MACLIST_PTR values */
    bwl_test_param_maclist_values[0] = (struct maclist*)malloc(
        sizeof(struct maclist) + sizeof(struct ether_addr) * 1);
    NN_SDK_ASSERT_NOT_NULL(bwl_test_param_maclist_values[0]);
    bwl_test_param_maclist_values[0]->count = 0;
    bwl_test_param_maclist_values[0]->ea[0] = {0, 0, 0, 0, 0 ,0};

    bwl_test_param_maclist_values[1] = (struct maclist*)malloc(
        sizeof(struct maclist) + sizeof(struct ether_addr) * 1);
    NN_SDK_ASSERT_NOT_NULL(bwl_test_param_maclist_values[0]);
    bwl_test_param_maclist_values[1]->count = (uint)(-1);
    bwl_test_param_maclist_values[1]->ea[0] = {0xff, 0xff, 0xff, 0xff, 0xff, 0xff};

    bwl_test_param_maclist_values[2] = (struct maclist*)malloc(
        sizeof(struct maclist) + sizeof(struct ether_addr) * 256);
    NN_SDK_ASSERT_NOT_NULL(bwl_test_param_maclist_values[0]);
    bwl_test_param_maclist_values[2]->count = 0xFFFFFFFF;
    for (i = 0; i < 256; i++) {
        bwl_test_param_maclist_values[2]->ea[i] =
            {0xff, 0xff, 0xff, 0xff, 0xff, 0xff};
    }
}

TestBwlApi::~TestBwlApi()
{
    int i = 0;
    for (i = 0; i < BWL_TEST_PARAM_MACLIST_NUM; i++) {
        free(bwl_test_param_maclist_values[i]);
        bwl_test_param_maclist_values[i] = nullptr;
    }
}

int TestBwlApi::Run()
{
    TEST_ENTER();
    InitTest();
    DeinitTest();
    InterfaceNullTest();
    InitedApiTest();
    DeinitedApiTest();
    InitedApiWithStructTest();
    DeinitedApiWithStructTest();
    Acsd();
    WpaSupplicant();
    TEST_LEAVE();
    return 0;
}

}
}

