﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>
#include "shell_CommandExecutor.h"

namespace nn { namespace shell {

class ProcessManagementExecutor : public CommandExecutor
{
public:
    ProcessManagementExecutor() NN_NOEXCEPT;
    virtual ~ProcessManagementExecutor() NN_NOEXCEPT;
    virtual void GetCommandDefinitions(const CommandDefinition** ppDefinitions, int *pCount) NN_NOEXCEPT;
    virtual int64_t Execute(const CommandExecuteContext* pContext, int commandIndex, int argc, const char* const* argv) NN_NOEXCEPT;
private:
    int64_t LaunchProgram(const char* path, size_t length, const void* pArgument, size_t argumentSize) NN_NOEXCEPT;
    int64_t GdbServerProgram(const CommandExecuteContext* pContext, const char* path, size_t length, uint32_t port, const void* pArgument, size_t argumentSize) NN_NOEXCEPT;
    int64_t TerminateProcess(Bit64 processId) NN_NOEXCEPT;
    int64_t AttachProcess(Bit64 processId, uint32_t port) NN_NOEXCEPT;

};

}}    // namespace nn { namespace shell {
