﻿// インターフェイスの定義ファイル
// C# で記述します。

// 以下の using ディレクティブを記述しておくと便利です。
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using nn;
using nn.sf;
using std;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;

namespace nn.profiler
{
    public interface IProfiler : IServiceObject
    {
        [MethodId(1)]
        Result GetSystemEvent(Out<nn.sf.NativeHandle> pOut);

        [MethodId(2)]
        Result StartSignalingEvent(int64_t ns); // DEPRECATED
        [MethodId(3)]
        Result StopSignalingEvent(); // DEPRECATED

        // API
        [MethodId(4)]
        Result LibraryInitialize(uint32_t sdkVersion, uint64_t processId);
        [MethodId(5)]
        Result LibraryFinalize(uint64_t processId);
        [MethodId(6)]
        Result GetProfilerStatus(Out<int32_t> pOutStatus);

        [MethodId(9)]
        Result GetIpcEvent(nn.sf.OutBuffer buffer);
        [MethodId(10)]
        Result CloseAndGetNextBuffer(Out<nn.sf.NativeHandle> pOut, uint64_t filledSize, uint32_t index);
        [MethodId(21)]
        Result CloseAndFinalizeBuffer(uint64_t filledSize, uint32_t index);

        [MethodId(11)]
        Result SendMessageToPcInBuffer(uint32_t id, nn.sf.InBuffer buffer, bool callback);
        [MethodId(18)]
        Result SendMessageToPcTransferMem(uint32_t id, uint64_t address, uint64_t size, bool callback);
        [MethodId(12)]
        Result StartMultipartMessageToPc(uint32_t id, uint64_t totalSize, uint32_t pieces, bool callback);
        [MethodId(13)]
        Result SendMultipartMessageToPcInBuffer(nn.sf.InBuffer buffer, uint32_t remaining);
        [MethodId(19)]
        Result SendMultipartMessageToPcTransferMem(uint64_t address, uint64_t size, uint32_t remaining);

        [MethodId(14)]
        Result GetProfileSettings(nn.sf.OutBuffer buffer);
        [MethodId(15)]
        Result SetProfileSettings(uint32_t affinityMask, uint32_t flags, uint32_t performanceCounterGroup, uint32_t sampleRate);

        [MethodId(16)]
        Result TransferSampleBuffers(nn.sf.NativeHandle handle, uint64_t originalAddress, uint64_t size);
        [MethodId(17)]
        Result SendSampleBufferAsMultipart(uint32_t blockId, uint64_t size, uint32_t remaining);

        [MethodId(20)]
        Result IsPcSynced(Out<bool> pOutIsSynced);

        [MethodId(22)]
        Result SendBuffer(nn.sf.InBuffer buffer, uint32_t type);

        [MethodId(23)]
        Result SendIpcMessage(uint32_t id, uint64_t data);

        // Next ID: 24
    }
}
