﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "profiler_Time.h"

namespace nn { namespace profiler {

class Timer
{
public:
    Timer() : m_totalTime(0), m_startTime(0), m_count(0) {}

    void Start()
    {
        m_startTime = GetCurrentTime();
    }

    void Stop()
    {
        if (m_startTime != 0)
        {
            m_totalTime += (GetCurrentTime() - m_startTime);
            ++m_count;
            m_startTime = 0;
        }
    }

    uint64_t GetAverageTime() const
    {
        return m_totalTime / m_count;
    }

    uint64_t GetCount() const
    {
        return m_count;
    }

    void Clear()
    {
        m_totalTime = 0;
        m_count = 0;
        m_startTime = 0;
    }

protected:
private:
    uint64_t m_totalTime;
    uint64_t m_startTime;
    uint64_t m_count;
};

#if defined(NN_PROFILER_TIMING_ENABLE)
#define NN_PROFILER_TIMING_BEGIN(timer) (timer)->Start()
#define NN_PROFILER_TIMING_END(timer)   (timer)->Stop()
#define NN_PROFILER_TIMING_CLEAR(timer) (timer)->Clear()
#else
#define NN_PROFILER_TIMING_BEGIN(timer) (static_cast<void>(0))
#define NN_PROFILER_TIMING_END(timer)   (static_cast<void>(0))
#define NN_PROFILER_TIMING_CLEAR(timer) (static_cast<void>(0))
#endif

}} // namespace nn::profiler
