﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdlib>

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>

namespace nn { namespace profiler {

    struct GnuBuildId
    {
        static const uint32_t GnuId = 0x00554e47;
        static const size_t MaximumBuildIdSize = 20;

        uint32_t unknownId1;
        uint32_t size;
        uint32_t unknownId2;
        uint32_t gnu;
        char buildId[MaximumBuildIdSize];

        void Fill(const void* address)
        {
            const uint32_t* ptr = static_cast<const uint32_t*>(address);
            unknownId1 = *ptr++;
            size = *ptr++;
            unknownId2 = *ptr++;
            gnu = *ptr++;

            NN_SDK_ASSERT_LESS_EQUAL(size, MaximumBuildIdSize);
            if (size > MaximumBuildIdSize)
            {
                size = MaximumBuildIdSize;
            }

            NN_SDK_ASSERT_EQUAL(gnu, GnuId);

            memcpy(buildId, ptr, size);
        }
    };

}} // namespace nn::profiler
