﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace profiler {

enum ProfilerCommMessage : uint32_t
{
    ProfilerCommMessage_Error = 10,
    ProfilerCommMessage_CrashReport = 11,
    ProfilerCommMessage_Output = 12,
    //ProfilerCommMessage_SetOutputState = 13,
    ProfilerCommMessage_Query = 20,
    ProfilerCommMessage_Argv = 21,
    ProfilerCommMessage_Version = 30,
    ProfilerCommMessage_AvailableProfilingModes = 31,
    ProfilerCommMessage_SetScenario = 40,
    //ProfilerCommMessage_KillApp = 41,
    //ProfilerCommMessage_NegotiateBufferSize = 90,
    ProfilerCommMessage_ApplicationInfo = 91,
    //ProfilerCommMessage_LoadError = 98,
    ProfilerCommMessage_ReadyToProfile = 99,
    ProfilerCommMessage_Start = 100,
    //ProfilerCommMessage_ModifyStatus = 101,
    ProfilerCommMessage_ProfilingStarted = 110,
    ProfilerCommMessage_Stop = 200,
    ProfilerCommMessage_TransferData = 300,
    ProfilerCommMessage_TransferThreads = 350,
    ProfilerCommMessage_TransferThreadNames = 351,
    ProfilerCommMessage_Reload = 400,
    ProfilerCommMessage_Log = 500,
    ProfilerCommMessage_Ro = 600,
    ProfilerCommMessage_CoreSelection = 700,
    ProfilerCommMessage_CoreAvailable = 701,
};

enum ProfilerIpcMessage : uint32_t
{
    ProfilerIpcMessage_AllDataSent,
    ProfilerIpcMessage_CoreMask,
    ProfilerIpcMessage_StartProfiling,
    ProfilerIpcMessage_StopProfiling,
    ProfilerIpcMessage_ForceAttachToInProcess,
};

enum MessageQuery : uint32_t
{
    MessageQuery_Invalid = 0,
    MessageQuery_IsLibraryInitialized = 1,
    MessageQuery_Dump = 2,
    MessageQuery_SupportsSystemProcess = 3,
};

enum SendBufferType : uint32_t
{
    SendBufferType_MarkerNames,
    SendBufferType_NvnTable,
};

}} // end namespace
