﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace profiler { namespace pmu {

    const int PerformanceCounterCount = 6;

    typedef uint16_t PerfCounterGroupDefinition[PerformanceCounterCount];

    enum PerformanceCounterFilter : uint16_t
    {
        PerformanceCounterFilter_None = 0,
        PerformanceCounterFilter_IgnoreEL1 = 0x8000,
        PerformanceCounterFilter_IgnoreEL0 = 0x4000,
    };

    enum PerfCounter : uint16_t
    {
        PerfCounter_SoftwareIncrement = 0x00,
        PerfCounter_L1InstructionCacheRefill = 0x01,
        PerfCounter_L1InstructionTlbRefill = 0x02,
        PerfCounter_L1DataCacheRefill = 0x03,
        PerfCounter_L1DataCacheAccess = 0x04,
        PerfCounter_L1DataCacheTlbRefill = 0x05,
        PerfCounter_ExecutedInstructionRetired = 0x08,
        PerfCounter_ExceptionTaken = 0x09,
        PerfCounter_ExceptionReturn = 0x0A,
        PerfCounter_ContextIdWriteRetired = 0x0B,
        PerfCounter_BranchMispredicted = 0x10,
        PerfCounter_CpuCycles = 0x11,
        PerfCounter_BranchPredicted = 0x12,
        PerfCounter_MemoryAccess = 0x13,
        PerfCounter_L1InstructionCacheAccess = 0x14,
        PerfCounter_L1DataCacheWriteBack = 0x15,
        PerfCounter_L2DataCacheAccess = 0x16,
        PerfCounter_L2DataCacheRefill = 0x17,
        PerfCounter_L2DataCacheWriteBack = 0x18,
        PerfCounter_BusAccess = 0x19,
        PerfCounter_MemoryError = 0x1A,
        PerfCounter_ExecutedInstructionSpec = 0x1B,
        PerfCounter_TranslationTableBaseWriteRetired = 0x1C,
        PerfCounter_BusCycle = 0x1D,
        PerfCounter_OddPerformanceCounterChainMode = 0x1E,
        PerfCounter_L1DataCacheRead = 0x40,
        PerfCounter_L1DataCacheWrite = 0x41,
        PerfCounter_L1DataCacheRefillRead = 0x42,
        PerfCounter_L1DataCacheRefillWrite = 0x43,
        PerfCounter_L1DataCacheWriteBackVictim = 0x46,
        PerfCounter_L1DataCacheWriteBackClean = 0x47,
        PerfCounter_L1DataCacheInvalidate = 0x48,
        PerfCounter_L1DataTlbRefillRead = 0x4C,
        PerfCounter_L1DataTlbRefillWrite = 0x4D,
        PerfCounter_L2DataCacheRead = 0x50,
        PerfCounter_L2DataCacheWrite = 0x51,
        PerfCounter_L2DataCacheRefillRead = 0x52,
        PerfCounter_L2DataCacheRefillWrite = 0x53,
        PerfCounter_L2DataCacheWriteBackVictim = 0x56,
        PerfCounter_L2DataCacheWriteBackClean = 0x57,
        PerfCounter_L2DataCacheInvalidate = 0x58,
        PerfCounter_BusAccessRead = 0x60,
        PerfCounter_BusAccessWrite = 0x61,
        PerfCounter_BusAccessShared = 0x62,
        PerfCounter_BusAccessNotShared = 0x63,
        PerfCounter_BusAccessNormal = 0x64,
        PerfCounter_BusAccessPeripheral = 0x65,
        PerfCounter_MemAccessRead = 0x66,
        PerfCounter_MemAccessWrite = 0x67,
        PerfCounter_UnalignedAccessReadSpec = 0x68,
        PerfCounter_UnalignedAccessWriteSpec = 0x69,
        PerfCounter_UnalignedAccessSpec = 0x6A,
        PerfCounter_ExecutedExclusiveLoadSpec = 0x6C,
        PerfCounter_ExecutedExclusiveStorePassSpec = 0x6D,
        PerfCounter_ExecutedExclusiveStoreFailSpec = 0x6E,
        PerfCounter_ExecutedLoadSpec = 0x70,
        PerfCounter_ExecutedStoreSpec = 0x71,
        PerfCounter_ExecutedLoadOrStoreSpec = 0x72,
        PerfCounter_ExecutedDataProcessingSpec = 0x73,
        PerfCounter_ExecutedAsimdSpec = 0x74,
        PerfCounter_ExecutedVfpSpec = 0x75,
        PerfCounter_ExecutedProgramCounterWriteSpec = 0x76,
        PerfCounter_ExecutedCryptoDataProcessingSpec = 0x77,
        PerfCounter_ExecutedBranchImmediateSpec = 0x78,
        PerfCounter_ExecutedBranchReturnSpec = 0x79,
        PerfCounter_ExecutedBranchIndirectSpec = 0x7A,
        PerfCounter_ExecutedBarrierIsbSpec = 0x7C,
        PerfCounter_ExecutedBarrierDsbSpec = 0x7D,
        PerfCounter_ExecutedBarrierDmbSpec = 0x7E,
        PerfCounter_ExceptionTakenUndefined = 0x81,
        PerfCounter_ExceptionTakenSvc = 0x82,
        PerfCounter_ExceptionTakenInstructionAbort = 0x83,
        PerfCounter_ExceptionTakenDataAbort = 0x84,
        PerfCounter_ExceptionTakenIrq = 0x86,
        PerfCounter_ExceptionTakenFiq = 0x87,
        PerfCounter_ExceptionTakenSmc = 0x88,
        PerfCounter_ExceptionTakenHvc = 0x8A,
        PerfCounter_ExceptionTrappedInstructionAbort = 0x8B,
        PerfCounter_ExceptionTrappedDataAbort = 0x8C,
        PerfCounter_ExceptionTrappedOther = 0x8D,
        PerfCounter_ExceptionTrappedIrq = 0x8E,
        PerfCounter_ExceptionTrappedFiq = 0x8F,
        PerfCounter_ExecutedLoadAcquireSpec = 0x90,
        PerfCounter_ExecutedStoreReleaseSpec = 0x91,
        PerfCounter_Disabled = 0x100,
        PerfCounter_CpuCycles_EL1 = PerformanceCounterFilter_IgnoreEL0 | PerfCounter_CpuCycles,
        PerfCounter_BusAccess_EL0 = PerformanceCounterFilter_IgnoreEL1 | PerfCounter_BusAccess,
        PerfCounter_BusAccess_EL1 = PerformanceCounterFilter_IgnoreEL0 | PerfCounter_BusAccess,
    };

    PerfCounterGroupDefinition* GetPerformanceCounterGroup(int index);

}}}
