﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "nvdrv.h"

/*
  Definition of port provided by nvservices.
  The feature set can be defined by bit flag.

  List of features:

  Please refer
  Externals/odin2/hos/services/src/resmgrs/nvrm/inc/nvdrv_drivers.h

  List of ports:

  nvdrv   - For usual game applications
  nvdrv:a - For applets
  nvdrv:s - For system processes
  nvdrv:t - For test programs (granted desc should not be signed)

 */
#define NVSERVICES_SERVICE_ENTRIES \
    { "nvdrv",    30, NvDrvPermission_Gpu |  \
                      NvDrvPermission_GpuDebug |  \
                      NvDrvPermission_VIC |  \
                      NvDrvPermission_UseGameCompbits | \
                      NvDrvPermission_UseGameSmmu | \
                      NvDrvPermission_VideoDecoder | \
                      NvDrvPermission_MemSafetyMarginCheck }, \
    { "nvdrv:a",  30, NvDrvPermission_Gpu |  \
                      NvDrvPermission_VIC |  \
                      NvDrvPermission_VideoDecoder | \
                      NvDrvPermission_ImportMemoryWeak | \
                      NvDrvPermission_JPEG }, \
    { "nvdrv:s",  30, NvDrvPermission_GpuDebug |  \
                      NvDrvPermission_GpuSchedule | \
                      NvDrvPermission_VIC |  \
                      NvDrvPermission_VideoEncoder | \
                      NvDrvPermission_JPEG | \
                      NvDrvPermission_Display | \
                      NvDrvPermission_ExportForAruid | \
                      NvDrvPermission_ImportMemory }, \
    { "nvdrv:t",  30, NvDrvPermission_All }, \
