﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/os.h>
#include <nn/fs.h>

#include "npns_PersistentData.h"

#define NN_NPNS_SAVEDATA_VOLUME        "npns_save"
#define NN_NPNS_SAVEDATA_FILENAME      "persistent.bin"
#define NN_NPNS_SAVEDATA_FULLPATH      NN_NPNS_SAVEDATA_VOLUME ":/" "persistent.bin"
#define NN_NPNS_SAVEDATA_ID            0x8000000000000110ULL                        // NOLINT(preprocessor/const)
#define NN_NPNS_SAVEDATA_STORAGE_SIZE  (128 * 1024)                                 // NOLINT(preprocessor/const)
#define NN_NPNS_SAVEDATA_JOURNAL_SIZE  ( 64 * 1024)                                 // NOLINT(preprocessor/const)
#define NN_NPNS_SAVEDATA_FLAGS         (nn::fs::SaveDataFlags_KeepAfterResettingSystemSaveDataWithoutUserSaveData) \
                                                                                    // NOLINT(preprocessor/const)
namespace nn{ namespace npns{

class SaveDataManager
{
    NN_DISALLOW_COPY( SaveDataManager );
    NN_DISALLOW_MOVE( SaveDataManager );

public:
    SaveDataManager();
    ~SaveDataManager();

    Result Initialize();
    void Finalize();

    Result Read(PersistentData* pData);
    Result Write(const PersistentData& data);

private:

};

}}


