﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_SystemThreadDefinition.h>

#define NN_NPNS_NETWORK_POLL_INTERVAL           50                                      // NOLINT(preprocessor/const)
#define NN_NPNS_NETWORK_WAIT_INTERVAL           50                                      // NOLINT(preprocessor/const)

#if     defined(NN_SDK_BUILD_DEBUG)
#   define NN_NPNS_THREAD_STACK_SIZE_CLIENT     (1024 * 64)                             // NOLINT(preprocessor/const)
#   define NN_NPNS_THREAD_STACK_SIZE_STATEMACHINE (1024 * 64)                             // NOLINT(preprocessor/const)
#   define NN_NPNS_THREAD_STACK_SIZE_EVENT      (1024 * 16)                             // NOLINT(preprocessor/const)
#else
#   define NN_NPNS_THREAD_STACK_SIZE_CLIENT     (1024 * 32)                             // NOLINT(preprocessor/const)
#   define NN_NPNS_THREAD_STACK_SIZE_STATEMACHINE (1024 * 64)                             // NOLINT(preprocessor/const)
#   define NN_NPNS_THREAD_STACK_SIZE_EVENT      (1024 * 16)                             // NOLINT(preprocessor/const)
#endif

#define NN_NPNS_CLIENT_NAME                     "npns"
#define NN_NPNS_CLIENT_VERSION                  "2.0.0"
#define NN_NPNS_DEFAULT_PORT                    443                                     // NOLINT(preprocessor/const)

//#define NN_NPNS_SERVER_ENVIRONMENT              "td1"
//#define NN_NPNS_SERVER_ENVIRONMENT              "dd1"
//#define NN_NPNS_SERVER_ENVIRONMENT              "jd1"
#ifndef NN_NPNS_SERVER_ENVIRONMENT
#   define NN_NPNS_SERVER_ENVIRONMENT           "%"
#endif

#define NN_NPNS_ENABLE_STANDARD_ALLOCATOR       1                                       // NOLINT(preprocessor/const)
//自律動作を有効にするか（未定義の場合は fwdbg を優先）
//#define NN_NPNS_ENABLE_AUTONOMY                 1 /* fwdbg:background_processing */     // NOLINT(preprocessor/const)
#define NN_NPNS_ENABLE_WOWLAN                   1                                       // NOLINT(preprocessor/const)
#define NN_NPNS_PLAYREPORT_INTERVAL_HOUR        24                                      // NOLINT(preprocessor/const)

#if 1
#define NN_NPNS_TEST_PROXY_HOST                 "proxy.nintendo.co.jp"
#define NN_NPNS_TEST_PROXY_PORT                 8080                                    // NOLINT(preprocessor/const)
#endif

#define NN_NPNS_TEST_HEAP_XMPP                  0                                       // NOLINT(preprocessor/const)
#define NN_NPNS_TEST_DISABLE_PSC                0                                       // NOLINT(preprocessor/const)
#define NN_NPNS_TEST_ALLOCATION_FAILURE         0                                       // NOLINT(preprocessor/const)

// スリープ時の間欠動作設定（コメントアウトで fwdbg 値をオーバライド）
//#define NN_NPNS_TEST_PERIODIC_INTERVAL_SECONDS  (60 * 60 * 3)                           // NOLINT(preprocessor/const)
//#define NN_NPNS_TEST_SLEEP_PROCESSING_TIMEOUT_SECONDS 60                                // NOLINT(preprocessor/const)
//#define NN_NPNS_TEST_TRY_MAX_COUNT_ON_HALFAWAKE 2                                       // NOLINT(preprocessor/const)

#if 0
#define NN_NPNS_TEST_PROXY_HOST                 "127.0.0.1"
#define NN_NPNS_TEST_PROXY_PORT                 3128                                    // NOLINT(preprocessor/const)
#define NN_NPNS_TEST_PROXY_USER                 "siglo"
#define NN_NPNS_TEST_PROXY_PASS                 "siglopass"
#endif

#ifdef NN_BUILD_CONFIG_OS_WIN
#   define NN_NPNS_TEST_USE_PROXY               1                                       // NOLINT(preprocessor/const)
#   define NN_NPNS_ENABLE_HIPC                  1                                       // NOLINT(preprocessor/const)
#   define NN_NPNS_SEPARATE_IPC_THREAD          1                                       // NOLINT(preprocessor/const)
#   define NN_NPNS_ENABLE_EULA_CHECK            0                                       // NOLINT(preprocessor/const)
#   define NN_NPNS_ENABLE_ONESHOT_NETWORK       1                                       // NOLINT(preprocessor/const)
#else
#   define NN_NPNS_TEST_USE_PROXY               0                                       // NOLINT(preprocessor/const)
#   define NN_NPNS_ENABLE_HIPC                  1                                       // NOLINT(preprocessor/const)
#   define NN_NPNS_SEPARATE_IPC_THREAD          0                                       // NOLINT(preprocessor/const)
#   define NN_NPNS_ENABLE_EULA_CHECK            1                                       // NOLINT(preprocessor/const)
#   define NN_NPNS_ENABLE_ONESHOT_NETWORK       1                                       // NOLINT(preprocessor/const)
#endif

#define NN_NPNS_TIMEOUT_ONLINE                  30                                      // NOLINT(preprocessor/const)
#define NN_NPNS_TIMEOUT_HTTP                    20                                      // NOLINT(preprocessor/const)
#define NN_NPNS_TIMEOUT_XMPP                    5                                       // NOLINT(preprocessor/const)
#define NN_NPNS_TIMEOUT_MS_SLEEP_IN             300                                     // NOLINT(preprocessor/const)
#define NN_NPNS_BACKOFF_SECONDS_INITIAL         3                                       // NOLINT(preprocessor/const)
#define NN_NPNS_BACKOFF_SECONDS_INCREMENT       30                                      // NOLINT(preprocessor/const)
#define NN_NPNS_BACKOFF_SECONDS_MAX             1800                                    // NOLINT(preprocessor/const)
#define NN_NPNS_TCP_KEEP_ALIVE_IDLE             60                                      // NOLINT(preprocessor/const)
#define NN_NPNS_TCP_KEEP_ALIVE_INTERVAL         10                                      // NOLINT(preprocessor/const)
#define NN_NPNS_TCP_KEEP_ALIVE_COUNT            2                                       // NOLINT(preprocessor/const)

// ビルド別ログ設定
#if     defined(NN_SDK_BUILD_DEBUG)
#   define NN_NPNS_ENABLE_BACKOFF_ON_ERROR      1                                       // NOLINT(preprocessor/const)
#   define NN_NPNS_ENABLE_LOG_VERBOSE           1                                       // NOLINT(preprocessor/const)
#   define NN_NPNS_ENABLE_LOG_XMPP              1                                       // NOLINT(preprocessor/const)
#   define NN_NPNS_ENABLE_LOG_SOCKET_MEMORY     1                                       // NOLINT(preprocessor/const)
//#   define NN_NPNS_ENABLE_LOGMANAGER            0 /* fwdbg:logmanager_redirection */    // NOLINT(preprocessor/const)
#   define NN_NPNS_DEBUG_HTTP                   1                                       // NOLINT(preprocessor/const)

#elif   defined(NN_SDK_BUILD_DEVELOP)
#   define NN_NPNS_ENABLE_BACKOFF_ON_ERROR      1                                       // NOLINT(preprocessor/const)
#   define NN_NPNS_ENABLE_LOG_VERBOSE           0                                       // NOLINT(preprocessor/const)
#   define NN_NPNS_ENABLE_LOG_XMPP              0                                       // NOLINT(preprocessor/const)
#   define NN_NPNS_ENABLE_LOG_SOCKET_MEMORY     0                                       // NOLINT(preprocessor/const)
//#   define NN_NPNS_ENABLE_LOGMANAGER            0 /* fwdbg:logmanager_redirection */    // NOLINT(preprocessor/const)
#   define NN_NPNS_DEBUG_HTTP                   0                                       // NOLINT(preprocessor/const)

#elif   defined(NN_SDK_BUILD_RELEASE)
#   define NN_NPNS_ENABLE_BACKOFF_ON_ERROR      1                                       // NOLINT(preprocessor/const)
#   define NN_NPNS_ENABLE_LOG_VERBOSE           0                                       // NOLINT(preprocessor/const)
#   define NN_NPNS_ENABLE_LOG_XMPP              0                                       // NOLINT(preprocessor/const)
#   define NN_NPNS_ENABLE_LOG_SOCKET_MEMORY     0                                       // NOLINT(preprocessor/const)
#   define NN_NPNS_ENABLE_LOGMANAGER            0 /* disable statically */                // NOLINT(preprocessor/const)
#   define NN_NPNS_DEBUG_HTTP                   0                                       // NOLINT(preprocessor/const)

#endif



