﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/npns.h>
#include <nn/npns/npns_Statistics.h>
#include <nn/npns/detail/npns_InternalTypes.h>
#include <nn/npns/detail/npns_Utility.h>

#include "npns_Config.h"
#include "npns_Log.h"
#include "npns_Instance.h"

#define NN_NPNS_THREAD_NAME(name)           NN_SYSTEM_THREAD_NAME(npns, name)
#define NN_NPNS_THREAD_PRIORITY(name)       NN_SYSTEM_THREAD_PRIORITY(npns, name)
#define NN_NPNS_THREAD_CONFIG(name)         NN_SYSTEM_THREAD_NAME(npns, name), NN_SYSTEM_THREAD_PRIORITY(npns, name)

#define NN_NPNS_RECORD_EVENT(name)          g_Daemon.GetStatistics().Increment(StatisticsKind_##name)
#define NN_NPNS_RECORD_ACCUMULATED_VALUE(name, value)  g_Daemon.GetStatistics().Add(StatisticsKind_##name, value)

