﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkLog.h>
#include <nn/init.h>
#include <nn/os.h>
#include <nn/account.h>
#include <nn/account/account_ApiForSystemServices.h>
#include <nn/npns/npns_Types.h>

#include "npns_Xmpp.h"
#include "npns_ClientSessionMaintainer.h"

namespace nn{ namespace npns{

//!< NPNS 独自のプロトコル実装を行うクラス. (XMPP の標準的なものは nn::npns::Xmpp クラスへ実装する)
class Client : public Xmpp
{
    NN_DISALLOW_COPY( Client );
    NN_DISALLOW_MOVE( Client );
    friend class ClientSessionMaintainer;
public:
    Client();

    void Initialize();
    virtual void RunOnce(unsigned long timeout);

    Result SubscribeTopic(const char* pTopicName);
    Result UnsubscribeTopic(const char* pTopicName);
    Result QueryIsTopicExist(bool* pIsExist, const char* pTopicName);

    TimeSpan GetBackoffWaitFromServer() const;

    enum Status
    {
        Status_Active,
        Status_Inactive
    };

    void SetStatus(Status status);
    Result EnableWhiteSpacePing(nn::os::Event* pEventInterrupt, bool isPowerModeNormal);
    void TriggerCheckConnection();
    Result CheckConnectionAndWait(os::SystemEvent* pCancelEvent, TimeSpan timeout);

    static bool ParseReceiverId(ReceiverId* pOut, const char * pSource);
    static bool ParseApplicationId(uint64_t* pOut, const char * pSource);
protected:
    virtual void OnReceiveMessageBody(const Text& text);
    virtual void OnReceiveDisconnectError(const Stanza& stanzaIncoming);
    virtual void OnReceiveIdle();
    virtual void OnConnected();
    virtual void OnBeforeDisconnect();
    virtual void OnFlush();

    static int IdleHandlerEntry(xmpp_conn_t * const, xmpp_stanza_t * const, void * const userdata);
private:
    void TriggerWhiteSpacePing();

    Result GetDeviceAccountIdList(int* pOutActualLen, uint64_t* pOutList, int outListLen) const;
    bool MakeUInt64Csv(char* pOut, size_t outSize, const char* format, uint64_t* values, int valueLen) const;
    Result SendDeviceAccountListAsync();

    Result SendOutOfHomeNetworkProfileAsync();
    Result SendSystemVersionAsync();

    void SendWhiteSpacePingModeAsync(const char* mode);
    bool ParseWhiteSpacePingIntervalStanza(TimeSpan* pOutNormal, TimeSpan* pOutLazy, const Stanza& stanzaIncoming) const;

    bool ParseBackoffStanza(TimeSpan* pOut, const Stanza& stanzaIncoming) const;

    ClientSessionMaintainer m_SessionMaintainer;
    NotificationData m_ndSendBuffer;

    nn::account::Notifier m_AccountNotifier;
    nn::os::SystemEvent m_AccountChangeEvent;

    TimeSpan m_backoffWaitFromServer;
    Status   m_InitialStatus;
};

}}


