﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/http.h>
#include <nn/account.h>
#include <nn/npns/npns_Types.h>

#include "npns_ResourceConsumerBase.h"

namespace nn{ namespace npns{

class ArrivalConsumer : public ResourceConsumerBase
{
    NN_DISALLOW_COPY(ArrivalConsumer);
    NN_DISALLOW_MOVE(ArrivalConsumer);
public:
    ArrivalConsumer(http::ConnectionBroker& cb, DeviceTokenHolder& dth);

    Result Check(bool* pIsArrival, int32_t* pWait, int32_t* pTry, const char* jid, os::Event* pCancelEvent);

private:
    Result SetupRequestParameters(http::Request* pRequest, const char* jid);
};


}}


