﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_Abort.h>
#include <nn/result/result_HandlingUtility.h>

#include <nn/init.h>
#include <nn/ro.h>
#include <nn/fatal/fatal_Api.h>

#include <nn/sf/sf_HipcServer.h>
#include <nn/sf/sf_ObjectFactory.h>

#include <nn/jitsrv/jitsrv_Service.h>

namespace nn { namespace jitsrv {

    struct MyHipcServerManagerOption
    {
        static const bool CanDeferInvokeRequest = false;
        static const int ObjectInSubDomainCountMax = 30;
        static const size_t PointerTransferBufferSize = 0;
        static const int SubDomainCountMax = 3;
    };

    class MyHipcServerManager
        : public sf::HipcSimpleAllInOneServerManager<MyHipcServerManagerOption::SubDomainCountMax, 1, MyHipcServerManagerOption>
    {
    };

    MyHipcServerManager g_MyHipcServerManager;

}}

extern "C" void PanicForPlugin() NN_NOEXCEPT
{
    NN_ABORT();
}

extern "C" void nninitStartup()
{
    nn::fatal::SetFatalPolicy(nn::fatal::FatalPolicy_OnlyErrorReport);
    const auto MemorySize = 2 * 1024 * 1024;
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::os::SetMemoryHeapSize(MemorySize));
    uintptr_t addr;
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::os::AllocateMemoryBlock(&addr, MemorySize));
    nn::init::InitializeAllocator(reinterpret_cast<void*>(addr), MemorySize);
}

extern "C" void nnMain() NN_NOEXCEPT
{
    using namespace nn;
    using namespace nn::jitsrv;
    nn::ro::Initialize();
    g_MyHipcServerManager.RegisterObjectForPort(GetJitService(), 1, "jit:u");
    NN_SDK_LOG("Start Jit Server\n");
    g_MyHipcServerManager.LoopAuto();
}
