﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_SdkLog.h>
#include <nn/nn_Result.h>
#include <nn/nn_Abort.h>
#include <nn/os/os_Thread.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/nn_SystemThreadDefinition.h>

#include "am_ScreenShotApplicationServer.h"

// for caps:su
#include "../../../../Iris/Sources/Libraries/capsrv/server/amsrv_InitializeForScreenShotApplicationServer.h"

namespace nn { namespace am { namespace service {

//-----------------------------------------------------------------------------

namespace {

    const size_t CapsrvScreenShotApplicationIpcThreadStackSize =  4 * 1024;
    NN_ALIGNAS(4096) char g_CapsrvScreenShotApplicationIpcThreadStack[CapsrvScreenShotApplicationIpcThreadStackSize];
    os::ThreadType g_CapsrvScreenShotApplicationIpcThread;

    void CapsrvScreenShotApplicationIpcThreadFunction(void*) NN_NOEXCEPT
    {
        capsrv::server::ScreenShotApplicationServerThreadFunction(nullptr);
    }

}

void SetupScreenShotApplicationServer() NN_NOEXCEPT
{
    capsrv::server::InitializeForScreenShotApplicationServer();

    NN_ABORT_UNLESS_RESULT_SUCCESS(
        os::CreateThread(
            &g_CapsrvScreenShotApplicationIpcThread,
            CapsrvScreenShotApplicationIpcThreadFunction,
            nullptr,
            g_CapsrvScreenShotApplicationIpcThreadStack,
            sizeof(g_CapsrvScreenShotApplicationIpcThreadStack),
            NN_SYSTEM_THREAD_PRIORITY(am, ScreenShotApplicationIpcServer)
        )
    );
    os::SetThreadNamePointer(&g_CapsrvScreenShotApplicationIpcThread, NN_SYSTEM_THREAD_NAME(am, ScreenShotApplicationIpcServer));
    os::StartThread(&g_CapsrvScreenShotApplicationIpcThread);
}

//-----------------------------------------------------------------------------

}}} // namespace nn::am::service

