﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_SdkLog.h>
#include <nn/nn_Result.h>
#include <nn/nn_Abort.h>
#include <nn/result/result_HandlingUtility.h>

#include "am_LaunchApplets.h"

namespace nn { namespace am { namespace service {

//-----------------------------------------------------------------------------

namespace {

Result LaunchSystemApplet(AppletService* p) NN_NOEXCEPT
{
    std::shared_ptr<core::Applet> systemApplet;
    auto result = p->GetAppletSystem().CreateSystemApplet(&systemApplet, applet::AppletId_SystemAppletMenu);
    if (!result.IsSuccess())
    {
        NN_SDK_LOG("[AM] Failed to create SystemApplet.\n");
        return result;
    }
    systemApplet->Start();
    NN_RESULT_SUCCESS;
}

Result LaunchOverlayApplet(AppletService* p) NN_NOEXCEPT
{
    std::shared_ptr<core::Applet> overlayApplet;
    auto result = p->GetAppletSystem().CreateOverlayApplet(&overlayApplet, applet::AppletId_OverlayApplet);
    if (!result.IsSuccess())
    {
        NN_SDK_LOG("[AM] Failed to create OverlayApplet.\n");
        return result;
    }
    overlayApplet->Start();
    NN_RESULT_SUCCESS;
}

}   // namespace

//-----------------------------------------------------------------------------

void LaunchApplets(AppletService* p) NN_NOEXCEPT
{
    LaunchSystemApplet(p);
    LaunchOverlayApplet(p);
}

//-----------------------------------------------------------------------------

}}} // namespace nn::am::service

