﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdint>
#include <nn/nn_Result.h>
#include <nn/os/os_Types.h>
#include <nn/sf/sf_Out.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/ncm/ncm_ProgramId.h>

class Server
{
public:
    nn::Result DebugNewProcess(nn::sf::Out<nn::sf::NativeHandle> eventHandle, nn::sf::Out<nn::os::ProcessId> outId, nn::ncm::ProgramId programId, std::int32_t port) NN_NOEXCEPT;
    nn::Result AttachProcess(nn::sf::Out<nn::sf::NativeHandle> eventHandle, nn::os::ProcessId processId, std::int32_t port) NN_NOEXCEPT;

    static void Initialize() NN_NOEXCEPT;
};

