﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/svc/svc_Dmnt.h>
#include "BreakPointManager.h"

namespace nn { namespace dmnt {

struct HardBreakPoint : public BreakPoint
{
    nn::svc::HardwareBreakPointRegisterName m_RegNumber;
    nn::svc::HardwareBreakPointRegisterName m_RegContext;

    void Initialize(nn::svc::HardwareBreakPointRegisterName reg, nn::svc::HardwareBreakPointRegisterName ctxReg)
    {
        m_RegNumber = reg;
        m_RegContext = ctxReg;
    }

    virtual nn::Result Set(DebugProcess *debugProcess, uintptr_t addr, size_t len, bool isStep);
    virtual nn::Result Clear(DebugProcess *debugProcess);
};

class HardwareBreakPoints : public BreakPointManager
{
public:
    explicit HardwareBreakPoints(DebugProcess *debugProcess);
    static const int NUM_BREAKPOINT = 16;

    static nn::Result SetHardwareBreakPoint( /*nn::svc::HardwareBreakPointRegisterName*/ uint32_t regNo,  nn::Bit64 control, nn::Bit64 value ) NN_NOEXCEPT;
    static nn::Result SetContextBreakpoint(nn::svc::HardwareBreakPointRegisterName regContext, nn::svc::Handle processDebuggerHandle) NN_NOEXCEPT;
    static nn::svc::HardwareBreakPointRegisterName GetWatchPointContextRegister();
    static nn::Result SetExecutionBreakpoint(nn::svc::HardwareBreakPointRegisterName regNo, nn::svc::HardwareBreakPointRegisterName regContext, nn::Bit64 address) NN_NOEXCEPT;
private:
    HardBreakPoint m_BreakPoints[NUM_BREAKPOINT];

    virtual BreakPoint *GetBreakPoint(unsigned index);

    static void CountBreakPointRegisters();
    static void MultiCoreThread( void* pArg );
    static bool SendMultiCoreRequest( void* pMultiCoreRequest );
};


}}

