﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include "xcd_CommandHandler.h"
#include "xcd_FirmwareVersionTypes.h"

namespace nn { namespace xcd {

//!< コントローラに搭載されたデバイスの抽象クラスです
class Peripheral
{
    NN_DISALLOW_COPY(Peripheral);
    NN_DISALLOW_MOVE(Peripheral);

protected:
    //!< コマンド制御用
    CommandHandler* m_pCommand;
    DeviceType m_Type;
    FirmwareVersionImpl m_FirmwareVersion;
    bool m_Activated;

public:
    Peripheral() NN_NOEXCEPT
        : m_Activated(false)
    {
        /* 何もしない */
    };
    virtual ~Peripheral() NN_NOEXCEPT { /* 何もしない */ };

    //!< デバイスが接続されたときに呼ばれる関数
    virtual void Activate(DeviceType type, FirmwareVersionImpl firmwareVersion) NN_NOEXCEPT
    {
        m_Activated = true;
        m_Type = type;
        m_FirmwareVersion = firmwareVersion;
    };
    //!< 接続直後の初期化処理が完了したかどうかを確認する関数。初期化が完了したら必ずtrueを返してください
    virtual bool IsActivated() NN_NOEXCEPT
    {
        return m_Activated;
    };
    //!< デバイスが切断された時に呼ばれる関数
    virtual void Deactivate() NN_NOEXCEPT { /* 何もしない */ };

    //!< OutputReportを送信するときに呼ばれる関数
    virtual size_t GetOutputReport(uint8_t* pOutValue, size_t size) NN_NOEXCEPT
    {
        NN_UNUSED(pOutValue);
        NN_UNUSED(size);
        // Do nothing
        return 0;
    };

    //!< InputReportを受信したときに呼ばれる関数
    virtual void ParseInputReport(const uint8_t* pBuffer, size_t size, uint8_t sampleNumber) NN_NOEXCEPT
    {
        NN_UNUSED(pBuffer);
        NN_UNUSED(size);
        NN_UNUSED(sampleNumber);
        // Do nothing
    };

    void SetCommandHandler(CommandHandler* pCommand) NN_NOEXCEPT
    {
        m_pCommand = pCommand;
    };
};

}} // namespace nn::xcd
