﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkAssert.h>
#include <nn/result/result_HandlingUtility.h>
#include "xcd_OutputGenerator.h"
#include "xcd_ReportTypes.h"
#include "xcd_CommandTypes.h"

namespace nn { namespace xcd {

uint8_t g_SamplingCount = 0;

OutputGenerator::OutputGenerator() NN_NOEXCEPT
    : m_DataFormat(PeriodicDataFormat_Basic)
    , m_SampleNumber(0)
{
}

OutputGenerator::~OutputGenerator() NN_NOEXCEPT
{
    // 何もしない
}

size_t OutputGenerator::GetHidReport(uint8_t* pOutValue, size_t size, bool commandOnly) NN_NOEXCEPT
{
    NN_UNUSED(size);
    NN_SDK_REQUIRES_NOT_NULL(pOutValue);

    size_t reportSize = 0;

    // Vibratorは総てのコマンドについている
    auto vibratorSize = m_pVibratorBase->GetOutputReport(&pOutValue[OutputReportByte_Vibrator], OutputReportSize_Vibrator);

    pOutValue[ReportByte_ReportId + 1] = 0xff;

    // Hid Commandは常に優先して送られる
    if(m_pCommand->GetOutputReport(&pOutValue[CommandOutReportByte_Payload], CommandOutReportSize_Payload) != 0)
    {
        // ReportIdをセット
        pOutValue[ReportByte_ReportId] = Report_CommandOut::Id;
        reportSize =  Report_CommandOut::Size;
    }
    else if (commandOnly == false)
    {
        // BasicOutReport を送信する
        if(m_DataFormat == PeriodicDataFormat_Basic)
        {
            if(vibratorSize != 0)
            {
                // 送信するVibrator Commandがある場合は送信する
                pOutValue[ReportByte_ReportId] = Report_BasicOut::Id;
                reportSize = Report_BasicOut::Size;
            }
        }
        // McuUpdateOutを送信する
        else if(m_DataFormat == PeriodicDataFormat_McuUpdate)
        {
            if(m_pTeraBase->GetMcuUpdateOutputReport(&pOutValue[McuUpdateOutReportByte_Payload], McuUpdateOutReportSize_Payload) != 0)
            {
                // ReportIdをセット
                pOutValue[ReportByte_ReportId] = Report_McuUpdateOut::Id;
                reportSize = Report_McuUpdateOut::Size;
            }
        }
        // McuOutを送信する
        else if(m_DataFormat == PeriodicDataFormat_MCU)
        {
            if(m_pTeraBase->GetOutputReport(&pOutValue[McuOutReportByte_Payload], McuOutReportSize_Payload) != 0)
            {
                // ReportIdをセット
                pOutValue[ReportByte_ReportId] = Report_McuOut::Id;
                reportSize =  Report_McuOut::Size;
            }
        }
        // AttachmentOutを送信する
        else if(m_DataFormat == PeriodicDataFormat_Attachment)
        {
            // TODO: 内部実装
        }
        // AudioOutを送信する
        else if(m_DataFormat == PeriodicDataFormat_Audio)
        {
            // Audio 対応デバイスが現状ない
        }
    }


    if (reportSize > 0)
    {
        // サンプル番号をセット
        pOutValue[OutputReportByte_SampleNumber] = m_SampleNumber;
        // サンプル番号をインクリメント
        if (++m_SampleNumber > 0x0f)
        {
            m_SampleNumber = 0;
        }
    }

    return reportSize;
}

}} // namespace nn::xcd
