﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <vector>
#include <nn/nn_Result.h>
#include <nn/nn_Macro.h>

namespace nn { namespace xcd {

//!< Main, Sub 色をもとに3, 4色目を追加します
inline DeviceColor ConvertColor(const DeviceColor& input) NN_NOEXCEPT
{
    static nn::util::Color4u8Type FullKeySubColor = { {255, 255, 255, 255} };
    static nn::util::Color4u8Type FullKeyMainColor01 = { {50, 50, 50, 255} };
    static nn::util::Color4u8Type FullKeyMainColor02 = { {49, 50, 50, 255} };
    static nn::util::Color4u8Type FullKeyMainColor03 = { {50, 49, 50, 255} };

    if (std::memcmp(&input.color[1], &FullKeySubColor, sizeof(nn::util::Color4u8Type)) == 0)
    {
        if (std::memcmp(&input.color[0], &FullKeyMainColor01, sizeof(nn::util::Color4u8Type)) == 0)
        {
            return nn::hid::detail::ColorSwitchProControllerDefault;
        }
        if (std::memcmp(&input.color[0], &FullKeyMainColor02, sizeof(nn::util::Color4u8Type)) == 0)
        {
            return nn::hid::detail::ColorSwitchProControllerBlitz;
        }
        if (std::memcmp(&input.color[0], &FullKeyMainColor03, sizeof(nn::util::Color4u8Type)) == 0)
        {
            return nn::hid::detail::ColorSwitchProControllerBigfolk2;
        }
    }

    return input;
}

}} // namespace nn::xcd
