﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkAssert.h>
#include <nn/result/result_HandlingUtility.h>

#include "xcd_UsbHidAccessor-os.horizon.h"

namespace nn { namespace xcd { namespace detail {


UsbHidAccessor::UsbHidAccessor() NN_NOEXCEPT
    : m_Activated(false)
{
    // 何もしない
}

UsbHidAccessor::~UsbHidAccessor() NN_NOEXCEPT
{
    // 何もしない
}

void UsbHidAccessor::Activate(DeviceHandle deviceHandle, UsbHidDriver* pDriver) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_EQUAL(m_Activated, false);
    NN_SDK_REQUIRES_NOT_NULL(pDriver);

    m_DeviceHandle = deviceHandle;
    m_pDriver = pDriver;

    m_Activated = true;
}

void UsbHidAccessor::Deactivate() NN_NOEXCEPT
{
    // サンプリングを中止
    StopSampling();

    // デバイスハンドルを初期化
    m_DeviceHandle = DeviceHandle::GetInvalidHandle();
    m_pDriver = nullptr;
    m_Activated = false;
}

void UsbHidAccessor::StartSampling(InputReportParserFunc func, void* pArg) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(func);
    NN_SDK_REQUIRES_NOT_NULL(pArg);
    NN_SDK_REQUIRES_EQUAL(m_Activated, true);

    m_pDriver->SetSampleParserFunction(func, pArg);
}

void UsbHidAccessor::StopSampling() NN_NOEXCEPT
{
    // 何もしない
}

void UsbHidAccessor::SetOutputReport(const uint8_t* pBuffer, size_t size) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pBuffer);
    NN_SDK_REQUIRES_EQUAL(m_Activated, true);

    // TODO Result ハンドリング
    m_pDriver->SetOutputReport(pBuffer, size);
}

void UsbHidAccessor::SetReport(ReportType reportType, uint8_t* pBuffer, size_t size, IHidListener* pListener) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pBuffer);
    NN_SDK_REQUIRES_NOT_NULL(pListener);
    NN_SDK_REQUIRES_EQUAL(m_Activated, true);
    NN_SDK_REQUIRES(size > 0);
    NN_UNUSED(reportType);
    NN_UNUSED(pBuffer);
    NN_UNUSED(size);
    NN_UNUSED(pListener);
}

void UsbHidAccessor::GetReport(ReportType reportType, uint8_t reportId, IHidListener* pListener) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_EQUAL(m_Activated, true);
    NN_SDK_REQUIRES_NOT_NULL(pListener);
    NN_UNUSED(reportType);
    NN_UNUSED(reportId);
    NN_UNUSED(pListener);
}

size_t UsbHidAccessor::GetInputReport(uint8_t* pOutValue, size_t size) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutValue);
    NN_SDK_REQUIRES_EQUAL(m_Activated, true);
    NN_SDK_REQUIRES(size > 0);

    return m_pDriver->GetInputReport(pOutValue, size);
}

Result UsbHidAccessor::GetInterval(::nn::TimeSpan* pOutInterval) NN_NOEXCEPT
{
    *pOutInterval = m_pDriver->GetInterval();
    NN_RESULT_SUCCESS;
}

void UsbHidAccessor::DetachDevice() NN_NOEXCEPT
{
    // Deactivate 済みの場合は何もしない
    if (m_Activated)
    {
        NN_SDK_REQUIRES_NOT_NULL(m_pDriver);
        m_pDriver->DeactivateUsbHidOnController();
    }
}

}}} // namespace nn::xcd::detail
