﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include "xcd_TeraCommon.h"

namespace nn { namespace xcd { namespace detail {

/**
 * @brief   TeraBase で使用するペイロード解析用の機能です。
 */
class TeraBaseParser
{
    NN_DISALLOW_COPY(TeraBaseParser);
    NN_DISALLOW_MOVE(TeraBaseParser);

public:
    /**
     * @brief   Common プロトコルの受信パケットを解析
     */
    static bool ParseCommonInputReport(
        CommonResponseType* pOutResponse,
        const uint8_t* pBuffer,
        size_t size) NN_NOEXCEPT;

    /**
     * @brief   IAP の受信パケットを解析
     */
    static bool ParseIapInputReport(
        uint8_t* pOutResultCode,
        const uint8_t* pBuffer,
        size_t size) NN_NOEXCEPT;

private:
    TeraBaseParser();  // 静的クラスなのでインスタンス生成を禁止
};

}}}
