﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>

#if defined(NN_BUILD_CONFIG_OS_WIN32)
    #include "xcd_LinkMonitorImpl-os.win32.h"
#elif defined(NN_BUILD_CONFIG_OS_HORIZON)
    #if defined(NN_BUILD_CONFIG_HARDWARE_NX)
        #include "xcd_LinkMonitorImpl-hardware.nx.h"
    #else
        #include "xcd_LinkMonitorImpl-os.horizon.default.h"
    #endif
#else
    #error   "未サポートの OS 種別が指定されています。"
#endif

namespace nn { namespace xcd { namespace detail{

ILinkMonitorImpl& GetLinkMonitor() NN_NOEXCEPT
{
    NN_FUNCTION_LOCAL_STATIC(LinkMonitorImpl, s_LinkMonitor);

    return s_LinkMonitor;
}

}}} // namespace nn::xcd::detail
