﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>

namespace nn { namespace xcd { namespace detail {

//!< InputReport を解析する関数
typedef void(*InputReportParserFunc)(void*, const uint8_t*, size_t);

//!< HID の実行結果を受け取るためのリスナークラスです。
class IHidListener
{
    NN_DISALLOW_COPY(IHidListener);
    NN_DISALLOW_MOVE(IHidListener);

public:
    IHidListener() NN_NOEXCEPT { /* 何もしない */ };
    virtual ~IHidListener() NN_NOEXCEPT { /* 何もしない */ };

/**
 * @brief      GetReport の処理が完了したときに呼ばれる通知です。
 *
 * @param[in]  pBuffer                      データ
 * @param[in]  size                         データのサイズ
 *
 */
    virtual void GetReportComplete(uint8_t* pBuffer, size_t size) NN_NOEXCEPT
    {
        NN_UNUSED(pBuffer);
        NN_UNUSED(size);
        // 何もしない
    };

/**
 * @brief      GetReport の処理が失敗したときに呼ばれる通知です。
 */
    virtual void GetReportFailed(int status) NN_NOEXCEPT
    {
        NN_UNUSED(status);
        // 何もしない
    };

/**
 * @brief      SetReport の処理が完了したときに呼ばれる通知です。
 *
 *
 */
    virtual void SetReportComplete(Result result) NN_NOEXCEPT
    {
        NN_UNUSED(result);
        // 何もしない
    };

/**
 * @brief      FirmwareUpdateMode への変更が完了した
 *
 *
 */
    virtual void FirmwareUpdateModeEnableComplete() NN_NOEXCEPT
    {
        // 何もしない
    };
};

}}} // namespace nn::xcd::detail
