﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>

#include "../xcd_BleReportTypes.h"

namespace nn { namespace xcd {
class IBleCommandListener;

namespace detail {
struct GattOperationPayload;

}}}

namespace nn { namespace xcd { namespace detail{

//!< Nintendo Hid over Gatt サービスのクライアント
class IBleNhogClient
{
public:
    IBleNhogClient() NN_NOEXCEPT { /* 何もしない */ };
    virtual ~IBleNhogClient() NN_NOEXCEPT { /* 何もしない */ };

    //!< GATT サーバに OutputCommand を書き込む。IBleCommandListener::CharacteristicWriteComplete で書き込みの完了を通知します
    virtual void WriteOutputCommandCharacteristicAsync(const GattOperationPayload& payload, IBleCommandListener* pListener) NN_NOEXCEPT
    {
        NN_UNUSED(payload);
        NN_UNUSED(pListener);
    };

    //!< GATT サーバから InputReport の ReportReference を読み込む。IBleCommandListener::DescriptorReadComplete で読み込みの完了を通知します
    virtual void ReadInputReportReportReferenceAsync(IBleCommandListener* pListener) NN_NOEXCEPT
    {
        NN_UNUSED(pListener);
    };

    //!< GATT サーバから OutputCommand の ReportReference を読み込む。IBleCommandListener::DescriptorReadComplete で読み込みの完了を通知します
    virtual void ReadOutputCommandReportReferenceAsync(IBleCommandListener* pListener) NN_NOEXCEPT
    {
        NN_UNUSED(pListener);
    };

    //!< GATT サーバから CommandResponse の ReportReference を読み込む。IBleCommandListener::DescriptorReadComplete で読み込みの完了を通知します
    virtual void ReadCommandResponseReportReferenceAsync(IBleCommandListener* pListener) NN_NOEXCEPT
    {
        NN_UNUSED(pListener);
    };

    //!< InputReport の Notification の有効/無効を設定する。IBleCommandListener::DescriptorWriteComplete で完了を通知します
    virtual void EnableInputReportNotification(IBleCommandListener* pListener, bool isEnabled) NN_NOEXCEPT
    {
        NN_UNUSED(pListener);
        NN_UNUSED(isEnabled);
    };

    //!< CommandResponse の Notification の有効/無効を設定する。IBleCommandListener::DescriptorWriteComplete で完了を通知します
    virtual void EnableCommandResponseNotification(IBleCommandListener* pListener, bool isEnabled) NN_NOEXCEPT
    {
        NN_UNUSED(pListener);
        NN_UNUSED(isEnabled);
    };

    //!< CommandResponse の Indication の有効/無効を設定する。IBleCommandListener::DescriptorWriteComplete で完了を通知します
    virtual void EnableCommandResponseIndication(IBleCommandListener* pListener, bool isEnabled) NN_NOEXCEPT
    {
        NN_UNUSED(pListener);
        NN_UNUSED(isEnabled);
    };

    //!< InputReport の FormatId を取得する
    virtual BleInputReportFormatVersion GetInputReportFormatVersion() NN_NOEXCEPT
    {
        return BleInputReportFormatVersion_Unknown;
    };

    //!< OutputCommand の FormatId を取得する
    virtual BleOutputCommandFormatVersion GetOutputCommandFormatVersion() NN_NOEXCEPT
    {
        return BleOutputCommandFormatVersion_Unknown;
    };

    //!< CommandResponse の FormatId を取得する
    virtual BleCommandResponseFormatVersion GetCommandResponseFormatVersion() NN_NOEXCEPT
    {
        return BleCommandResponseFormatVersion_Unknown;
    };
};

}}} // namespace nn::xcd::detail
