﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/bluetooth/bluetooth_Types.h>
#include "xcd_BleGattClientTypes.h"

namespace nn { namespace btm { namespace user {
struct GattService;
}}}

namespace nn { namespace xcd {
class IBleCommandListener;
}}

namespace nn { namespace xcd { namespace detail{

//!< GATT クライアントの各アトリビュートの状態を示す情報
struct GattClientAttributeParameter
{
    bool isValid;
    nn::bluetooth::GattAttributeType type; //!< キャラクタリスティックかデスクリプタを示す
    uint8_t               index;          //!< GATT クライアントが持つアトリビュートの Index
    nn::bluetooth::GattId service;        //!< サービスの Instance ID, UUID
    bool                  isPrimary;      //!< サービスが Primary かどうか
    nn::bluetooth::GattId characteristic; //!< キャラクタリスティックの Instance ID, UUID
    nn::bluetooth::GattId descriptor;     //!< デスクリプタの Instance ID, UUID。ReadDescriptor/WriteDescriptor の場合に使う
};

struct GattOperationConfig
{
    GattOperationStatus   opStatus;         //!< 操作の状態
    GattOperationType     opType;           //!< 操作タイプ
    uint8_t               authType;         //!< Auth Type。定義はよくわからない
    GattClientAttributeParameter parameter; //!< 操作するアトリビュートの情報
    GattOperationPayload  payload;          //!< 送信するデータ。WriteCharacteristic/WriteDescriptor の場合に使う
    IBleCommandListener*  pListener;        //!< 結果を受け取るリスナー
};

//!< 汎用的な GATT クライアントを扱うクラス
class IBleGattClient
{
protected:
    //!< Attribute リストサイズ
    static const int MaxAttributeListSize = 5;
    //!< GATT 操作のキューサイズ
    static const int MaxOperationCount = 10;

    //!< Device Name など文字列の最大長。終端を含む。Advertise のサイズにしておく
    static const int MaxStringLength = 31;

public:
    IBleGattClient() NN_NOEXCEPT { /* 何もしない */};
    virtual ~IBleGattClient() NN_NOEXCEPT { /* 何もしない */ };

    //!< GATT サーバからの応答のハンドラ。ハンドリング結果を返します
    virtual bool GattOperationCompletedHandler(nn::bluetooth::InfoFromLeGattOperationCallback* pGattResult) NN_NOEXCEPT = 0;

    //!< GATT クライアントを有効にする
    virtual void Activate(uint32_t connectionHandle, const nn::btm::user::GattService& service) NN_NOEXCEPT = 0;

    //!< GATT クライアントを無効にする
    virtual void Deactivate() NN_NOEXCEPT = 0;

    //!< Activate されているかどうか
    virtual bool IsActivated() NN_NOEXCEPT = 0;

    //!< サービスの UUID を返す
    virtual const nn::bluetooth::GattAttributeUuid* GetServiceUuid() NN_NOEXCEPT = 0;

    //!< サービスのハンドルを返す
    virtual uint16_t GetServiceHandle() NN_NOEXCEPT = 0;
};

}}} // namespace nn::xcd::detail
